/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.config;

import org.infinispan.spring.config.InfinispanNamespaceUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class InfinispanContainerCacheManagerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String DEFAULT_CACHE_MANAGER_BEAN_NAME = "cacheManager";
    private static final String FACTORY_BEAN_CLASS = "org.infinispan.spring.provider.ContainerEmbeddedCacheManagerFactoryBean";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)FACTORY_BEAN_CLASS);
        String cacheContainerRef = element.getAttribute("cache-container-ref");
        BeanComponentDefinition innerBean = InfinispanNamespaceUtils.parseInnerBeanDefinition(element, parserContext);
        if (innerBean != null) {
            parserContext.registerBeanComponent(innerBean);
        }
        if (!StringUtils.hasText((String)cacheContainerRef) && innerBean == null || StringUtils.hasText((String)cacheContainerRef) && innerBean != null) {
            parserContext.getReaderContext().error("Exactly one of the 'cache-container-ref' attribute or an inner bean definition is required for a 'container-cache-manager' element", (Object)element);
        }
        beanDefinitionBuilder.addConstructorArgReference(innerBean != null ? innerBean.getBeanName() : cacheContainerRef);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = DEFAULT_CACHE_MANAGER_BEAN_NAME;
        }
        return id;
    }
}

