/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.builders.SpringEmbeddedCacheManagerFactoryBeanBuilder;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.provider.SpringEmbeddedCacheManagerFactoryBean;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringEmbeddedCacheManagerFactoryBeanTest", groups={"unit"})
public class SpringEmbeddedCacheManagerFactoryBeanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";
    private SpringEmbeddedCacheManagerFactoryBean objectUnderTest;

    @AfterClass(alwaysRun=true)
    public void closeCacheManager() throws Exception {
        if (this.objectUnderTest != null) {
            this.objectUnderTest.destroy();
        }
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanCreatesACacheManagerEvenIfNoDefaultConfigurationLocationHasBeenSet() throws Exception {
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().build();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid SpringEmbeddedCacheManager, even if no defaulConfigurationLocation has been specified. However, it returned null.", (Object)springEmbeddedCacheManager);
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanCreatesACustomizedCacheManagerIfGivenADefaultConfigurationLocation() throws Exception {
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().fromFile(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass()).build();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid SpringEmbeddedCacheManager, configured using the configuration file set on SpringEmbeddedCacheManagerFactoryBean. However, it returned null.", (Object)springEmbeddedCacheManager);
        SpringCache cacheDefinedInCustomConfiguration = springEmbeddedCacheManager.getCache(CACHE_NAME_FROM_CONFIGURATION_FILE);
        Configuration configuration = ((Cache)cacheDefinedInCustomConfiguration.getNativeCache()).getCacheConfiguration();
        AssertJUnit.assertEquals((String)"The cache named [asyncCache] is configured to have asynchonous replication cache mode. Yet, the cache returned from getCache(asyncCache) has a different cache mode. Obviously, SpringEmbeddedCacheManagerFactoryBean did not use the configuration file when instantiating SpringEmbeddedCacheManager.", (Object)CacheMode.REPL_ASYNC, (Object)configuration.clustering().cacheMode());
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanReportsTheCorrectObjectType() throws Exception {
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().build();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"getObjectType() should return the most derived class of the actual SpringEmbeddedCacheManager implementation returned from getObject(). However, it didn't.", springEmbeddedCacheManager.getClass(), (Object)this.objectUnderTest.getObjectType());
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanDeclaresItselfToOnlyProduceSingletons() {
        this.objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true. However, it returned false", (boolean)this.objectUnderTest.isSingleton());
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanStopsTheCreatedEmbeddedCacheManagerWhenBeingDestroyed() throws Exception {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.defaultCacheName("default");
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().withGlobalConfiguration(builder).build();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = this.objectUnderTest.getObject();
        springEmbeddedCacheManager.getCache("default");
        this.objectUnderTest.destroy();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should stop the created SpringEmbeddedCacheManager when being destroyed. However, the created SpringEmbeddedCacheManager is still not terminated.", (Object)ComponentStatus.TERMINATED, (Object)springEmbeddedCacheManager.getNativeCacheManager().getStatus());
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanAllowesOverridingGlobalConfiguration() throws Exception {
        GlobalConfigurationBuilder overriddenConfiguration = new GlobalConfigurationBuilder();
        overriddenConfiguration.transport().rackId("r2");
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().fromFile(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass()).withGlobalConfiguration(overriddenConfiguration).build();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"Transport for cache configured inasyncCacheis assigned to r1 rack. But later Global Configuration overrides this setting to r2. Obviously created SpringEmbeddedCacheManagerFactoryBean does not support this kind of overriding.", (String)"r2", (String)springEmbeddedCacheManager.getNativeCacheManager().getCacheManagerConfiguration().transport().rackId());
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanAllowesOverridingConfigurationBuilder() throws Exception {
        ConfigurationBuilder overriddenBuilder = new ConfigurationBuilder();
        overriddenBuilder.locking().concurrencyLevel(100);
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().fromFile(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass()).withConfigurationBuilder(overriddenBuilder).build();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"Concurrency value of LockingLocking for cache configured inasyncCacheis equal to 5000. But later Configuration Builder overrides this setting to 100. Obviously created SpringEmbeddedCacheManagerFactoryBean does not support this kind of overriding.", (int)100, (int)springEmbeddedCacheManager.getNativeCacheManager().getDefaultCacheConfiguration().locking().concurrencyLevel());
    }

    @Test
    public void testIfSpringEmbeddedCacheManagerFactoryBeanAllowesOverridingConfigurationWithEmptyInputStream() throws Exception {
        this.objectUnderTest = SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().build();
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        this.objectUnderTest.addCustomGlobalConfiguration(gcb);
        this.objectUnderTest.addCustomCacheConfiguration(builder);
        this.objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager infinispanEmbeddedCacheManager = this.objectUnderTest.getObject().getNativeCacheManager();
        AssertJUnit.assertEquals((boolean)infinispanEmbeddedCacheManager.getCacheManagerConfiguration().globalJmxStatistics().allowDuplicateDomains(), (boolean)true);
        AssertJUnit.assertEquals((boolean)infinispanEmbeddedCacheManager.getDefaultCacheConfiguration().transaction().transactionMode().isTransactional(), (boolean)false);
    }
}

