/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session;

import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.session.InfinispanEmbeddedSessionRepository;
import org.infinispan.spring.session.InfinispanSessionRepositoryTCK;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.session.InfinispanEmbeddedSessionRepositoryTest", groups={"unit"})
public class InfinispanEmbeddedSessionRepositoryTest
extends InfinispanSessionRepositoryTCK {
    private EmbeddedCacheManager embeddedCacheManager;

    @BeforeClass
    public void beforeClass() {
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager();
    }

    @AfterMethod
    public void afterMethod() {
        this.embeddedCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.embeddedCacheManager.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.embeddedCacheManager.getCache());
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) throws Exception {
        InfinispanEmbeddedSessionRepository sessionRepository = new InfinispanEmbeddedSessionRepository(springCache);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        super.testThrowingExceptionOnNullSpringCache();
    }

    public void testCreatingSession() throws Exception {
        super.testCreatingSession();
    }

    public void testSavingSession() throws Exception {
        super.testSavingSession();
    }

    public void testDeletingSession() throws Exception {
        super.testDeletingSession();
    }

    public void testEvictingSession() throws Exception {
        super.testEvictingSession();
    }

    public void testExtractingPrincipalWithWrongIndexName() throws Exception {
        super.testExtractingPrincipalWithWrongIndexName();
    }

    public void testExtractingPrincipal() throws Exception {
        super.testExtractingPrincipal();
    }

    public void testUpdatingTTLOnAccessingData() throws Exception {
        super.testUpdatingTTLOnAccessingData();
    }
}

