/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.infinispan.spring.builders.SpringEmbeddedCacheManagerFactoryBeanBuilder;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.provider.sample.AbstractTestTemplateJsr107;
import org.infinispan.spring.provider.sample.service.CachedBookService;
import org.infinispan.spring.provider.sample.service.CachedBookServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SampleJavaConfigurationTest", groups={"functional"}, sequential=true)
@org.springframework.test.context.ContextConfiguration(classes={ContextConfiguration.class}, loader=AnnotationConfigContextLoader.class)
public class SampleJavaConfigurationTest
extends AbstractTestTemplateJsr107 {
    @Autowired(required=true)
    private SpringEmbeddedCacheManager cacheManager;
    @Qualifier(value="cachedBookService")
    @Autowired(required=true)
    private CachedBookService bookService;

    @Override
    public CachedBookService getBookService() {
        return this.bookService;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Configuration
    @ComponentScan(basePackages={"org.infinispan.spring.provider.sample.dao", "org.infinispan.spring.provider.sample.generators", "org.infinispan.spring.provider.sample.resolvers", "org.infinispan.spring.provider.sample.service"})
    @EnableCaching
    @EnableTransactionManagement
    static class ContextConfiguration {
        @Value(value="classpath:/org/infinispan/spring/provider/sample/initDB.sql")
        private Resource initScript;
        @Value(value="classpath:/org/infinispan/spring/provider/sample/populateDB.sql")
        private Resource populateScript;

        ContextConfiguration() {
        }

        @Bean
        public CachedBookService cachedBookService() {
            return new CachedBookServiceImpl();
        }

        @Bean
        public SpringEmbeddedCacheManager cacheManager() throws Exception {
            return SpringEmbeddedCacheManagerFactoryBeanBuilder.defaultBuilder().fromFile("books-infinispan-config.xml", this.getClass()).build().getObject();
        }

        @Bean(destroyMethod="close")
        public DataSource basicDataSource() {
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName("org.h2.Driver");
            dataSource.setUrl("jdbc:h2:mem:bookstoreEnableCaching");
            dataSource.setUsername("sa");
            dataSource.setPassword("");
            return dataSource;
        }

        @Bean
        public DataSourceInitializer dataSourceInitializer(DataSource dataSource) {
            DataSourceInitializer initializer = new DataSourceInitializer();
            initializer.setDataSource(dataSource);
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            populator.addScript(this.initScript);
            populator.addScript(this.populateScript);
            initializer.setDatabasePopulator((DatabasePopulator)populator);
            return initializer;
        }

        @Bean
        public DataSourceTransactionManager transactionManager(DataSource dataSource) {
            return new DataSourceTransactionManager(dataSource);
        }
    }
}

