/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session;

import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.session.InfinispanApplicationPublishedBridgeTCK;
import org.infinispan.spring.session.InfinispanEmbeddedSessionRepository;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.session.EmbeddedApplicationPublishedBridgeTest", groups={"unit"})
public class EmbeddedApplicationPublishedBridgeTest
extends InfinispanApplicationPublishedBridgeTCK {
    private EmbeddedCacheManager embeddedCacheManager;

    @BeforeClass
    public void beforeClass() {
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager();
    }

    @AfterMethod
    public void afterMethod() {
        this.embeddedCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.embeddedCacheManager.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.embeddedCacheManager.getCache());
    }

    protected void callEviction() {
        this.embeddedCacheManager.getCache().getAdvancedCache().getExpirationManager().processExpiration();
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) throws Exception {
        InfinispanEmbeddedSessionRepository sessionRepository = new InfinispanEmbeddedSessionRepository(springCache);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    public void testEventBridge() throws Exception {
        super.testEventBridge();
    }

    public void testUnregistration() throws Exception {
        super.testUnregistration();
    }
}

