/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBean;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBeanTest", groups={"unit"})
public class InfinispanEmbeddedCacheManagerFactoryBeanTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldCreateACacheManagerEvenIfNoDefaultConfigurationLocationHasBeenSet() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertNotNull((String)"getObject() should have returned a valid EmbeddedCacheManager, even if no defaulConfigurationLocation has been specified. However, it returned null.", (Object)this.cm);
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldCreateACustomizedCacheManagerIfGivenADefaultConfigurationLocation() throws Exception {
        ClassPathResource infinispanConfig = new ClassPathResource(NAMED_ASYNC_CACHE_CONFIG_LOCATION, ((Object)((Object)this)).getClass());
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setConfigurationFileLocation((Resource)infinispanConfig);
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertNotNull((String)"getObject() should have returned a valid EmbeddedCacheManager, configured using the configuration file set on SpringEmbeddedCacheManagerFactoryBean. However, it returned null.", (Object)this.cm);
                Cache cacheDefinedInCustomConfiguration = this.cm.getCache(InfinispanEmbeddedCacheManagerFactoryBeanTest.CACHE_NAME_FROM_CONFIGURATION_FILE);
                Configuration configuration = cacheDefinedInCustomConfiguration.getCacheConfiguration();
                AssertJUnit.assertEquals((String)"The cache named [asyncCache] is configured to have asynchonous replication cache mode. Yet, the cache returned from getCache(asyncCache) has a different cache mode. Obviously, SpringEmbeddedCacheManagerFactoryBean did not use the configuration file when instantiating EmbeddedCacheManager.", (Object)CacheMode.REPL_ASYNC, (Object)configuration.clustering().cacheMode());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldReportTheCorrectObjectType() throws Exception {
        final InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"getObjectType() should return the most derived class of the actual EmbeddedCacheManager implementation returned from getObject(). However, it didn't.", this.cm.getClass(), (Object)objectUnderTest.getObjectType());
            }
        });
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldDeclareItselfToOnlyProduceSingletons() {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true. However, it returned false", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldStopTheCreateEmbeddedCacheManagerWhenBeingDestroyed() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        final EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        embeddedCacheManager.getCache();
        objectUnderTest.destroy();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(objectUnderTest.getObject()){

            public void call() {
                AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should stop the created EmbeddedCacheManager when being destroyed. However, the created EmbeddedCacheManager is still not terminated.", (Object)ComponentStatus.TERMINATED, (Object)embeddedCacheManager.getStatus());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAddConfigurations() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        try {
            GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
            objectUnderTest.addCustomGlobalConfiguration(gcb);
            objectUnderTest.addCustomCacheConfiguration(builder);
            objectUnderTest.afterPropertiesSet();
            EmbeddedCacheManager infinispanEmbeddedCacheManager = objectUnderTest.getObject();
            AssertJUnit.assertEquals((boolean)infinispanEmbeddedCacheManager.getCacheManagerConfiguration().globalJmxStatistics().allowDuplicateDomains(), (boolean)gcb.build().globalJmxStatistics().allowDuplicateDomains());
            AssertJUnit.assertEquals((boolean)infinispanEmbeddedCacheManager.getDefaultCacheConfiguration().transaction().transactionMode().isTransactional(), (boolean)builder.build().transaction().transactionMode().isTransactional());
        }
        finally {
            objectUnderTest.destroy();
        }
    }
}

