/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.session.AbstractApplicationPublisherBridge;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.session.MapSession;
import org.springframework.session.SessionRepository;

public abstract class AbstractInfinispanSessionRepository
implements SessionRepository<MapSession>,
ApplicationEventPublisherAware,
InitializingBean,
DisposableBean {
    protected final AbstractApplicationPublisherBridge applicationEventPublisher;
    protected final SpringCache cache;

    protected AbstractInfinispanSessionRepository(SpringCache cache, AbstractApplicationPublisherBridge eventsBridge) {
        Objects.requireNonNull(cache, "SpringCache can not be null");
        Objects.requireNonNull(eventsBridge, "EventBridge can not be null");
        this.applicationEventPublisher = eventsBridge;
        this.cache = cache;
    }

    public void afterPropertiesSet() throws Exception {
        this.applicationEventPublisher.registerListener();
    }

    public void destroy() throws Exception {
        this.applicationEventPublisher.unregisterListener();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher.setApplicationEventPublisher(applicationEventPublisher);
    }

    public MapSession createSession() {
        MapSession result = new MapSession();
        result.setCreationTime(System.currentTimeMillis());
        return result;
    }

    public void save(MapSession session) {
        this.cache.put(session.getId(), session, session.getMaxInactiveIntervalInSeconds(), TimeUnit.SECONDS);
    }

    public MapSession getSession(String id) {
        return this.getSession(id, true);
    }

    public MapSession getSession(String id, boolean updateTTL) {
        return Optional.ofNullable(this.cache.get(id)).map(v -> (MapSession)v.get()).map(v -> this.updateTTL((MapSession)v, updateTTL)).orElse(null);
    }

    protected MapSession updateTTL(MapSession session, boolean updateTTL) {
        if (updateTTL) {
            session.setLastAccessedTime(System.currentTimeMillis());
            this.cache.put(session.getId(), session, session.getMaxInactiveIntervalInSeconds(), TimeUnit.SECONDS);
        }
        return session;
    }

    public void delete(String id) {
        this.applicationEventPublisher.emitSessionDeletedEvent(id);
        this.cache.evict(id);
    }
}

