/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.spring.provider.SpringRemoteCacheManager;
import org.infinispan.spring.test.InfinispanTestExecutionListener;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringRemoteCacheManagerFactoryBeanContextTest", groups={"unit"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/provider/SpringRemoteCacheManagerFactoryBeanContextTest.xml"})
@TestExecutionListeners(value={InfinispanTestExecutionListener.class})
public class SpringRemoteCacheManagerFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String SPRING_REMOTE_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME = "springRemoteCacheManagerWithDefaultConfiguration";
    private static final String SPRING_REMOTE_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_PROPERTIES_FILE_BEAN_NAME = "springRemoteCacheManagerConfiguredFromConfigurationPropertiesFile";
    private static final String SPRING_REMOTE_CACHE_MANAGER_CONFIGURED_USING_CONFIGURATION_PROPERTIES_BEAN_NAME = "springRemoteCacheManagerConfiguredUsingConfigurationProperties";
    private static final String SPRING_REMOTE_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME = "springRemoteCacheManagerConfiguredUsingSetters";

    @Test
    public final void shouldCreateARemoteCacheManagerWithDefaultSettingsIfNoFurtherConfigurationGiven() {
        SpringRemoteCacheManager springRemoteCacheManagerWithDefaultConfiguration = (SpringRemoteCacheManager)this.applicationContext.getBean(SPRING_REMOTE_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME, SpringRemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringRemoteCacheManager with default settings having bean name = \"springRemoteCacheManagerWithDefaultConfiguration\". However, it doesn't.", (Object)springRemoteCacheManagerWithDefaultConfiguration);
    }

    @Test
    public final void shouldCreateARemoteCacheManagerConfiguredFromConfigurationFileIfConfigurationFileLocationGiven() {
        SpringRemoteCacheManager springRemoteCacheManagerConfiguredFromConfigurationFile = (SpringRemoteCacheManager)this.applicationContext.getBean(SPRING_REMOTE_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_PROPERTIES_FILE_BEAN_NAME, SpringRemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringRemoteCacheManager configured from configuration file having bean name = \"springRemoteCacheManagerConfiguredFromConfigurationPropertiesFile\". However, it doesn't.", (Object)springRemoteCacheManagerConfiguredFromConfigurationFile);
    }

    @Test
    public final void shouldCreateARemoteCacheManagerConfiguredUsingConfigurationPropertiesSetInApplicationContext() {
        SpringRemoteCacheManager springRemoteCacheManagerConfiguredUsingConfigurationProperties = (SpringRemoteCacheManager)this.applicationContext.getBean(SPRING_REMOTE_CACHE_MANAGER_CONFIGURED_USING_CONFIGURATION_PROPERTIES_BEAN_NAME, SpringRemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringRemoteCacheManager configured using configuration properties set in application context having bean name = \"springRemoteCacheManagerConfiguredUsingConfigurationProperties\". However, it doesn't.", (Object)springRemoteCacheManagerConfiguredUsingConfigurationProperties);
        AssertJUnit.assertEquals((long)500L, (long)springRemoteCacheManagerConfiguredUsingConfigurationProperties.getReadTimeout());
        AssertJUnit.assertEquals((long)700L, (long)springRemoteCacheManagerConfiguredUsingConfigurationProperties.getWriteTimeout());
    }

    @Test
    public final void shouldCreateARemoteCacheManagerConfiguredUsingSettersIfPropertiesAreDefined() {
        SpringRemoteCacheManager springRemoteCacheManagerConfiguredUsingSetters = (SpringRemoteCacheManager)this.applicationContext.getBean(SPRING_REMOTE_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME, SpringRemoteCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a SpringRemoteCacheManager configured using properties having bean name = \"springRemoteCacheManagerConfiguredUsingSetters\". However, it doesn't.", (Object)springRemoteCacheManagerConfiguredUsingSetters);
    }
}

