/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.AbstractEmbeddedCacheManagerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class InfinispanEmbeddedCacheManagerFactoryBean
extends AbstractEmbeddedCacheManagerFactory
implements FactoryBean<EmbeddedCacheManager>,
InitializingBean,
DisposableBean {
    private EmbeddedCacheManager cacheManager;

    public void afterPropertiesSet() throws Exception {
        logger.info((Object)"Initializing Infinispan EmbeddedCacheManager instance ...");
        this.cacheManager = this.createBackingEmbeddedCacheManager();
        logger.info((Object)("Successfully initialized Infinispan EmbeddedCacheManager instance [" + this.cacheManager + "]"));
    }

    public EmbeddedCacheManager getObject() throws Exception {
        return this.cacheManager;
    }

    public Class<? extends EmbeddedCacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : EmbeddedCacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }
}

