/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.test.AbstractInfinispanTest;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class InfinispanSessionRepositoryTCK
extends AbstractInfinispanTest {
    protected SpringCache springCache;
    protected AbstractInfinispanSessionRepository sessionRepository;

    protected abstract SpringCache createSpringCache();

    protected abstract AbstractInfinispanSessionRepository createRepository(SpringCache var1) throws Exception;

    protected void init() throws Exception {
        this.springCache = this.createSpringCache();
        this.sessionRepository = this.createRepository(this.springCache);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        this.createRepository(null);
    }

    @Test
    public void testCreatingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        Assert.assertNotNull((Object)(session.getId() != null ? 1 : 0));
        Assert.assertNotNull((Object)session.getCreationTime());
        Assert.assertNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test
    public void testSavingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        Assert.assertNotNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test
    public void testUpdatingTTLOnAccessingData() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        Instant accessTimeBeforeSaving = session.getLastAccessedTime();
        this.sessionRepository.save(session);
        Instant accessTimeAfterSaving = session.getLastAccessedTime();
        Instant accessTimeAfterAccessing = this.sessionRepository.findById(session.getId()).getLastAccessedTime();
        Assert.assertNotNull((Object)accessTimeBeforeSaving);
        Assert.assertTrue((boolean)accessTimeBeforeSaving.isBefore(Instant.now()));
        Assert.assertNotNull((Object)accessTimeAfterSaving);
        Assert.assertTrue((boolean)accessTimeAfterSaving.isBefore(Instant.now()));
        Assert.assertNotNull((Object)accessTimeAfterAccessing);
        Assert.assertTrue((boolean)accessTimeAfterAccessing.isAfter(accessTimeAfterSaving));
    }

    @Test
    public void testDeletingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        this.sessionRepository.deleteById(session.getId());
        Assert.assertNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test(timeOut=5000L)
    public void testEvictingSession() throws Exception {
        MapSession session = this.sessionRepository.createSession();
        session.setMaxInactiveInterval(Duration.ofSeconds(1L));
        this.sessionRepository.save(session);
        while (this.sessionRepository.getSession(session.getId(), false) != null) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
    }

    @Test
    public void testExtractingPrincipalWithWrongIndexName() throws Exception {
        int sizeWithWrongIndexName = this.sessionRepository.findByIndexNameAndIndexValue("wrongIndexName", "").size();
        int sizeWithNullIndexName = this.sessionRepository.findByIndexNameAndIndexValue(null, "").size();
        Assert.assertTrue((sizeWithNullIndexName == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sizeWithWrongIndexName == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExtractingPrincipal() throws Exception {
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test1");
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test2");
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test3");
        int numberOfTest1Users = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, "test1").size();
        int numberOfNonExistingUsers = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, "notExisting").size();
        Assert.assertTrue((numberOfTest1Users == 1 ? 1 : 0) != 0);
        Assert.assertTrue((numberOfNonExistingUsers == 0 ? 1 : 0) != 0);
    }

    protected void addEmptySessionWithPrincipal(AbstractInfinispanSessionRepository sessionRepository, String principalName) {
        MapSession session = sessionRepository.createSession();
        session.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)principalName);
        sessionRepository.save(session);
    }
}

