/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.util.EventsWaiter;
import org.infinispan.test.AbstractInfinispanTest;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.session.MapSession;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class InfinispanApplicationPublishedBridgeTCK
extends AbstractInfinispanTest {
    protected SpringCache springCache;
    protected AbstractInfinispanSessionRepository sessionRepository;

    protected abstract SpringCache createSpringCache();

    protected abstract void callEviction();

    protected abstract AbstractInfinispanSessionRepository createRepository(SpringCache var1) throws Exception;

    @Test
    public void testEventBridge() throws Exception {
        EventsCollector eventsCollector = new EventsCollector();
        this.sessionRepository.setApplicationEventPublisher((ApplicationEventPublisher)eventsCollector);
        MapSession sessionToBeDeleted = this.sessionRepository.createSession();
        sessionToBeDeleted.setAttribute("foo", (Object)"bar");
        this.sessionRepository.save(sessionToBeDeleted);
        MapSession sessionToBeExpired = this.sessionRepository.createSession();
        sessionToBeExpired.setMaxInactiveInterval(Duration.ofSeconds(1L));
        this.sessionRepository.save(sessionToBeExpired);
        this.sessionRepository.save(sessionToBeDeleted);
        this.sessionRepository.deleteById(sessionToBeDeleted.getId());
        this.sleepOneSecond();
        this.callEviction();
        Assert.assertNull((Object)this.springCache.get((Object)sessionToBeExpired.getId()));
        Assert.assertNull((Object)this.springCache.get((Object)sessionToBeDeleted.getId()));
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionCreatedEvent.class, 2, 2, TimeUnit.SECONDS);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionDeletedEvent.class, 1, 2, TimeUnit.SECONDS);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionDestroyedEvent.class, 1, 10, TimeUnit.SECONDS);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionExpiredEvent.class, 1, 2, TimeUnit.SECONDS);
        EventsWaiter.assertSessionContent(() -> eventsCollector.getEvents(), SessionDeletedEvent.class, sessionToBeDeleted.getId(), "foo", "bar", 2, TimeUnit.SECONDS);
    }

    @Test
    public void testEventBridgeWithSessionIdChange() throws Exception {
        EventsCollector eventsCollector = new EventsCollector();
        this.sessionRepository.setApplicationEventPublisher((ApplicationEventPublisher)eventsCollector);
        MapSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        session.changeSessionId();
        this.sessionRepository.save(session);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionCreatedEvent.class, 2, 2, TimeUnit.SECONDS);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionDeletedEvent.class, 0, 2, TimeUnit.SECONDS);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionDestroyedEvent.class, 0, 2, TimeUnit.SECONDS);
        EventsWaiter.assertNumberOfEvents(() -> eventsCollector.getEvents(), SessionExpiredEvent.class, 0, 2, TimeUnit.SECONDS);
    }

    protected void init() throws Exception {
        this.springCache = this.createSpringCache();
        this.sessionRepository = this.createRepository(this.springCache);
    }

    private void sleepOneSecond() {
        long oneSecondSleep = System.currentTimeMillis() + 1000L;
        this.eventually(() -> System.currentTimeMillis() > oneSecondSleep);
    }

    @Test
    public void testUnregistration() throws Exception {
        EventsCollector eventsCollector = new EventsCollector();
        this.sessionRepository.setApplicationEventPublisher((ApplicationEventPublisher)eventsCollector);
        this.sessionRepository.destroy();
        MapSession sessionToBeExpired = this.sessionRepository.createSession();
        this.sessionRepository.save(sessionToBeExpired);
        Assert.assertEquals((long)eventsCollector.getEvents().count(), (long)0L);
    }

    static class EventsCollector
    implements ApplicationEventPublisher {
        private List<ApplicationEvent> events = new CopyOnWriteArrayList<ApplicationEvent>();

        EventsCollector() {
        }

        public void publishEvent(ApplicationEvent event) {
            this.events.add(event);
        }

        public void publishEvent(Object event) {
            this.publishEvent((ApplicationEvent)new PayloadApplicationEvent((Object)this, event));
        }

        public Stream<ApplicationEvent> getEvents() {
            return this.events.stream();
        }
    }
}

