/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded;

import java.io.IOException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.core.io.Resource;

public class AbstractEmbeddedCacheManagerFactory {
    private static final Log logger = LogFactory.getLog(AbstractEmbeddedCacheManagerFactory.class);
    private Resource configurationFileLocation;
    private GlobalConfigurationBuilder gcb;
    private ConfigurationBuilder builder;

    protected EmbeddedCacheManager createBackingEmbeddedCacheManager() throws IOException {
        if (this.configurationFileLocation != null) {
            ConfigurationBuilderHolder configurationBuilderHolder = new ParserRegistry(Thread.currentThread().getContextClassLoader()).parse(this.configurationFileLocation.getURL());
            if (this.gcb != null) {
                configurationBuilderHolder.getGlobalConfigurationBuilder().read(this.gcb.build());
            }
            if (this.builder != null) {
                ConfigurationBuilder dcb = configurationBuilderHolder.getDefaultConfigurationBuilder();
                if (dcb != null) {
                    dcb.read(this.builder.build());
                } else {
                    throw logger.noDefaultCache();
                }
            }
            return new DefaultCacheManager(configurationBuilderHolder, true);
        }
        if (this.gcb == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"GlobalConfigurationBuilder is null. Using default new instance.");
            }
            this.gcb = new GlobalConfigurationBuilder();
        }
        if (this.builder == null) {
            return new DefaultCacheManager(this.gcb.build());
        }
        return new DefaultCacheManager(this.gcb.build(), this.builder.build());
    }

    public void setConfigurationFileLocation(Resource configurationFileLocation) {
        this.configurationFileLocation = configurationFileLocation;
    }

    public void addCustomGlobalConfiguration(GlobalConfigurationBuilder gcb) {
        this.gcb = gcb;
    }

    public void addCustomCacheConfiguration(ConfigurationBuilder builder) {
        this.builder = builder;
    }
}

