/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider.sample;

import java.lang.invoke.MethodHandles;
import java.util.Random;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.embedded.provider.sample.entity.Book;
import org.infinispan.spring.embedded.provider.sample.service.CachedBookService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.cache.CacheManager;
import org.springframework.test.context.testng.AbstractTransactionalTestNGSpringContextTests;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractTestTemplate
extends AbstractTransactionalTestNGSpringContextTests {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    @AfterMethod
    public void clearBookCache() {
        this.booksCache().clear();
        this.backupCache().clear();
    }

    @Test
    public void demonstrateCachingLoadedBooks() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBook(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void demonstrateRemovingBookFromCache() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (this.booksCache().get((Object)bookToDeleteId).equals(bookToDelete)) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBook(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void demonstrateCacheEvictionUponUpdate() {
        Integer bookToUpdateId = 2;
        assert (!this.booksCache().containsKey((Object)bookToUpdateId)) : "Cache should not initially contain the book with id " + bookToUpdateId;
        log.infof("Caching book [ID = %d]", (Object)bookToUpdateId);
        Book bookToUpdate = this.getBookService().findBook(bookToUpdateId);
        assert (this.booksCache().get((Object)bookToUpdateId).equals(bookToUpdate)) : "findBook(" + bookToUpdateId + ") should have cached book";
        log.infof("Updating book [%s] ...", (Object)bookToUpdate);
        bookToUpdate.setTitle("Work in Progress");
        this.getBookService().updateBook(bookToUpdate);
        log.infof("Book [%s] updated", (Object)bookToUpdate);
        assert (!this.booksCache().containsKey((Object)bookToUpdateId)) : "updateBook(" + bookToUpdate + ") should have removed updated book from cache";
    }

    @Test
    public void demonstrateCachePutOnCreate() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBook(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (this.booksCache().get((Object)bookToCreate.getId()).equals(bookToCreate)) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testFindCustomCacheResolver() {
        Integer bookToCacheId = 5;
        assert (!this.getCache("custom").containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCustomCacheResolver(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.getCache("custom").get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testFindCustomKeyGenerator() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCustomKeyGenerator(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testFindConditionMet() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCondition(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testFindConditionNotMet() {
        Integer bookToCacheId = 1;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCondition(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "findBook(" + bookToCacheId + ") should not have cached book";
    }

    @Test
    public void testFindUnlessMet() {
        Integer bookToCacheId = 1;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookUnless(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testFindUnlessNotMet() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookUnless(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "findBook(" + bookToCacheId + ") should not have cached book";
    }

    @Test
    public void testFindCustomCacheManager() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCustomCacheManager(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testCreateCustomCacheManager() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCustomCacheManager(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)bookToCreate.getId()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateCustomCacheResolver() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCustomCacheResolver(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.getCache("custom").get((Object)bookToCreate.getId()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateCustomKeyGenerator() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCustomKeyGenerator(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (this.booksCache().containsKey((Object)bookToCreate)) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateConditionMet() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        Book result = this.getBookService().createBookCondition(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)result.getId()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateConditionNotMet() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Wrong Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCondition(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.getId() != null) : "Book.id should have been set.";
        assert (!this.booksCache().containsKey((Object)bookToCreate.getId())) : "createBook(" + bookToCreate + ") should not have inserted created book into cache";
    }

    @Test
    public void testCreateUnlessMet() {
        Book bookToCreate = new Book("99-999-999", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookUnless(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)bookToCreate.getId()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCreateUnlessNotMet() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookUnless(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (!this.booksCache().containsKey((Object)bookToCreate.getId())) : "createBook(" + bookToCreate + ") should not have inserted created book into cache";
    }

    @Test
    public void testDeleteCustomCacheResolver() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.getCache("custom").containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBookCustomCacheResolver(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.getId() != null) : "Book.id should have been set.";
        assert (bookToDelete.equals(this.getCache("custom").get((Object)bookToDelete.getId()))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCustomCacheResolver(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.getCache("custom").containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteCustomKeyGenerator() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCustomKeyGenerator(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteConditionMet() {
        Integer bookToDeleteId = 2;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCondition(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteConditionNotMet() {
        Integer bookToDeleteId = 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCondition(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDeleteId))) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteAllEntries() {
        Integer bookToDeleteId1 = 5;
        Integer bookToDeleteId2 = 6;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId1)) : "Cache should not initially contain the book with id " + bookToDeleteId1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId2)) : "Cache should not initially contain the book with id " + bookToDeleteId2;
        Book bookToDelete1 = this.getBookService().findBook(bookToDeleteId1);
        log.infof("Book [%s] cached", (Object)bookToDelete1);
        assert (bookToDelete1.equals(this.booksCache().get((Object)bookToDeleteId1))) : "findBook(" + bookToDeleteId1 + ") should have cached book";
        Book bookToDelete2 = this.getBookService().findBook(bookToDeleteId2);
        log.infof("Book [%s] cached", (Object)bookToDelete2);
        assert (bookToDelete2.equals(this.booksCache().get((Object)bookToDeleteId2))) : "findBook(" + bookToDeleteId2 + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete1);
        this.getBookService().deleteBookAllEntries(bookToDeleteId1);
        log.infof("Book [%s] deleted", (Object)bookToDelete1);
        assert (!this.booksCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete1 + ") should have evicted book from cache.";
        assert (!this.booksCache().containsKey((Object)bookToDelete2.getId())) : "deleteBook(" + bookToDelete2 + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteCustomCacheManager() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBookCustomCacheManager(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.getId() != null) : "Book.id should have been set.";
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDelete.getId()))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.getBookService().deleteBookCustomCacheManager(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testDeleteBookBeforeInvocation() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.getBookService().findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (bookToDelete.equals(this.booksCache().get((Object)bookToDelete.getId()))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        try {
            this.getBookService().deleteBookBeforeInvocation(bookToDeleteId);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDelete.getId())) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void testCachingCreate() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        this.getBookService().createBookCachingBackup(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (bookToCreate.equals(this.booksCache().get((Object)bookToCreate.getId()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
        assert (bookToCreate.equals(this.backupCache().get((Object)bookToCreate.getId()))) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testCachingFind() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        assert (!this.backupCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.getBookService().findBookCachingBackup(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)cachedBook.getId()))) : "findBook(" + bookToCacheId + ") should have cached book";
        assert (cachedBook.equals(this.backupCache().get((Object)cachedBook.getId()))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void testCachingDelete() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        assert (!this.backupCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete1 = this.getBookService().findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete1);
        Book bookToDelete2 = this.getBookService().findBookBackup(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete2);
        assert (bookToDelete1.equals(this.booksCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        assert (bookToDelete1.equals(this.backupCache().get((Object)bookToDeleteId))) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete1);
        this.getBookService().deleteBookCachingBackup(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete1);
        assert (!this.booksCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete1 + ") should have evicted book from cache.";
        assert (!this.backupCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete2 + ") should have evicted book from cache.";
    }

    protected BasicCache<Object, Object> booksCache() {
        return (BasicCache)this.getCacheManager().getCache("books").getNativeCache();
    }

    protected BasicCache<Object, Object> backupCache() {
        return (BasicCache)this.getCacheManager().getCache("backup").getNativeCache();
    }

    protected BasicCache<Object, Object> getCache(String name) {
        return (BasicCache)this.getCacheManager().getCache(name).getNativeCache();
    }

    public abstract CachedBookService getBookService();

    public abstract CacheManager getCacheManager();
}

