/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.session;

import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.InfinispanSessionRepositoryTCK;
import org.infinispan.spring.embedded.session.InfinispanEmbeddedSessionRepository;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="spring.embedded.session.InfinispanEmbeddedSessionRepositoryTest", groups={"unit"})
public class InfinispanEmbeddedSessionRepositoryTest
extends InfinispanSessionRepositoryTCK {
    private EmbeddedCacheManager embeddedCacheManager;
    private EmbeddedCacheManager cacheManager2;
    private EmbeddedCacheManager cacheManager3;

    @Factory
    public Object[] factory() {
        return new Object[]{new InfinispanEmbeddedSessionRepositoryTest().mediaType(MediaType.APPLICATION_PROTOSTREAM), new InfinispanEmbeddedSessionRepositoryTest().mediaType(MediaType.APPLICATION_SERIALIZED_OBJECT)};
    }

    @BeforeClass
    public void beforeClass() {
        ConfigurationBuilder defaultCacheBuilder = new ConfigurationBuilder();
        defaultCacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).encoding().mediaType(this.mediaType.getTypeSubtype());
        this.embeddedCacheManager = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)defaultCacheBuilder);
        this.cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)defaultCacheBuilder);
        this.cacheManager3 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)defaultCacheBuilder);
    }

    @AfterMethod
    public void afterMethod() {
        this.embeddedCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.embeddedCacheManager.stop();
        this.cacheManager2.stop();
        this.cacheManager3.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.embeddedCacheManager.getCache());
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) {
        InfinispanEmbeddedSessionRepository sessionRepository = new InfinispanEmbeddedSessionRepository(springCache);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        super.testThrowingExceptionOnNullSpringCache();
    }

    public void testCreatingSession() throws Exception {
        super.testCreatingSession();
    }

    public void testSavingSession() throws Exception {
        super.testSavingSession();
    }

    public void testDeletingSession() throws Exception {
        super.testDeletingSession();
    }

    public void testEvictingSession() throws Exception {
        super.testEvictingSession();
    }

    public void testExtractingPrincipalWithWrongIndexName() throws Exception {
        super.testExtractingPrincipalWithWrongIndexName();
    }

    public void testExtractingPrincipal() throws Exception {
        super.testExtractingPrincipal();
    }

    public void testUpdatingTTLOnAccessingData() throws Exception {
        super.testUpdatingTTLOnAccessingData();
    }
}

