/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider.sample;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.common.InfinispanTestExecutionListener;
import org.infinispan.spring.embedded.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.embedded.provider.sample.entity.Book;
import org.infinispan.spring.embedded.provider.sample.service.CachedTransactionBookService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTransactionalTestNGSpringContextTests;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="spring.embedded.provider.SampleTransactionIntegrationTest", groups={"functional"}, sequential=true)
@ContextConfiguration(locations={"classpath:/org/infinispan/spring/embedded/provider/sample/SampleTransactionIntegrationTestConfig.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@TestExecutionListeners(value={InfinispanTestExecutionListener.class})
public class SampleTransactionIntegrationTest
extends AbstractTransactionalTestNGSpringContextTests {
    @Qualifier(value="cachedTransactionBookServiceImpl")
    @Autowired(required=true)
    private CachedTransactionBookService bookService;
    @Autowired(required=true)
    private SpringEmbeddedCacheManager cacheManager;

    @AfterMethod
    public void clean() {
        this.transactionalCache().clear();
        this.nonTransactionalCache().clear();
    }

    @Test
    public void testUsingTemplate() throws SystemException {
        Book[] created = new Book[2];
        Book[] found = new Book[2];
        TransactionManager tm = this.getTransactionManager("booksTransactional");
        assert (tm.getStatus() == 0) : "Transaction should be in state 'RUNNING'";
        Book nonTxBook = new Book("1-1-2-3-5", "Random author", "Title");
        Book txBook = new Book("1-2-2-4-8", "Not so random author", "Title");
        created[0] = this.bookService.createBookTransactionalCache(nonTxBook);
        found[0] = this.bookService.findBookTransactionalCache(9);
        created[1] = this.bookService.createBookNonTransactionalCache(txBook);
        found[1] = this.bookService.findBookNonTransactionalCache(9);
        tm.rollback();
        assert (!this.transactionalCache().values().contains(created[0]));
        assert (!this.transactionalCache().values().contains(found[0]));
        assert (this.nonTransactionalCache().values().contains(created[1]));
        assert (this.nonTransactionalCache().values().contains(found[1]));
        assert (this.bookService.findBookCacheDisabled(created[0].getId()) == null);
        assert (this.bookService.findBookCacheDisabled(created[1].getId()) == null);
    }

    @Test
    public void testUsingTemplateNoRollback() throws SystemException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        Book[] created = new Book[2];
        Book[] found = new Book[2];
        assert (!this.transactionalCache().containsKey((Object)9));
        TransactionManager tm = this.getTransactionManager("booksTransactional");
        assert (tm.getStatus() == 0) : "Transaction should be in state 'RUNNING'";
        Book nonTxBook = new Book("1-1-2-3-5", "Random author", "Title");
        Book txBook = new Book("1-2-2-4-8", "Not so random author", "Title");
        created[0] = this.bookService.createBookTransactionalCache(nonTxBook);
        found[0] = this.bookService.findBookTransactionalCache(9);
        created[1] = this.bookService.createBookNonTransactionalCache(txBook);
        found[1] = this.bookService.findBookNonTransactionalCache(9);
        tm.commit();
        assert (this.transactionalCache().values().contains(created[0]));
        assert (this.transactionalCache().values().contains(found[0]));
        assert (this.nonTransactionalCache().values().contains(created[1]));
        assert (this.nonTransactionalCache().values().contains(found[1]));
        assert (this.bookService.findBookCacheDisabled(created[0].getId()) != null);
        assert (this.bookService.findBookCacheDisabled(created[1].getId()) != null);
    }

    private TransactionManager getTransactionManager(String cacheName) {
        Cache cache = (Cache)this.cacheManager.getCache(cacheName).getNativeCache();
        return cache.getAdvancedCache().getTransactionManager();
    }

    private BasicCache<Object, Object> nonTransactionalCache() {
        return this.cacheManager.getCache("books").getNativeCache();
    }

    private BasicCache<Object, Object> transactionalCache() {
        return this.cacheManager.getCache("booksTransactional").getNativeCache();
    }
}

