/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider.sample.service;

import org.infinispan.spring.embedded.provider.sample.dao.BaseBookDao;
import org.infinispan.spring.embedded.provider.sample.entity.Book;
import org.infinispan.spring.embedded.provider.sample.service.CachedTransactionBookService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class CachedTransactionBookServiceImpl
implements CachedTransactionBookService {
    @Autowired
    private BaseBookDao baseDao;

    @Override
    @CachePut(value={"books"}, key="#book.id")
    public Book createBookNonTransactionalCache(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @CachePut(value={"booksTransactional"}, key="#book.id")
    public Book createBookTransactionalCache(Book book) {
        return this.baseDao.createBook(book);
    }

    @Override
    @Cacheable(value={"books"})
    public Book findBookNonTransactionalCache(Integer id) {
        return this.baseDao.findBook(id);
    }

    @Override
    @Cacheable(value={"booksTransactional"})
    public Book findBookTransactionalCache(Integer id) {
        return this.baseDao.findBook(id);
    }

    @Override
    public Book findBookCacheDisabled(Integer id) {
        return this.baseDao.findBook(id);
    }
}

