/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.support;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.embedded.support.InfinispanNamedEmbeddedCacheFactoryBean;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.core.io.ClassPathResource;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="spring.embedded.support.InfinispanNamedEmbeddedCacheFactoryBeanTest", groups={"unit"})
public class InfinispanNamedEmbeddedCacheFactoryBeanTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final ClassPathResource NAMED_ASYNC_CACHE_CONFIG_LOCATION = new ClassPathResource("named-async-cache.xml", InfinispanNamedEmbeddedCacheFactoryBeanTest.class);
    private EmbeddedCacheManager DEFAULT_CACHE_MANAGER;
    private EmbeddedCacheManager PRECONFIGURED_DEFAULT_CACHE_MANAGER;

    @BeforeClass
    public void startCacheManagers() {
        this.DEFAULT_CACHE_MANAGER = TestCacheManagerFactory.createCacheManager();
        Configuration configuration = new ConfigurationBuilder().build();
        this.DEFAULT_CACHE_MANAGER.defineConfiguration("test.cache.Name", configuration);
        this.DEFAULT_CACHE_MANAGER.defineConfiguration("test.bean.Name", configuration);
        this.DEFAULT_CACHE_MANAGER.start();
        try (InputStream configStream = NAMED_ASYNC_CACHE_CONFIG_LOCATION.getInputStream();){
            this.PRECONFIGURED_DEFAULT_CACHE_MANAGER = TestCacheManagerFactory.fromStream((InputStream)configStream);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @AfterClass
    public void stopCacheManagers() {
        this.PRECONFIGURED_DEFAULT_CACHE_MANAGER.stop();
        this.DEFAULT_CACHE_MANAGER.stop();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldRecognizeThatNoCacheContainerHasBeenSet() throws Exception {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setCacheName("test.cache.Name");
        objectUnderTest.setBeanName("test.bean.Name");
        objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldUseBeanNameAsCacheNameIfNoCacheNameHasBeenSet() throws Exception {
        String beanName = "test.bean.Name";
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setBeanName("test.bean.Name");
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"InfinispanNamedEmbeddedCacheFactoryBean should have used its bean name [test.bean.Name] as the name of the created cache. However, it didn't.", (String)"test.bean.Name", (String)cache.getName());
        objectUnderTest.destroy();
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldPreferExplicitCacheNameToBeanName() throws Exception {
        String cacheName = "test.cache.Name";
        String beanName = "test.bean.Name";
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName("test.cache.Name");
        objectUnderTest.setBeanName("test.bean.Name");
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"InfinispanNamedEmbeddedCacheFactoryBean should have preferred its cache name [test.cache.Name] as the name of the created cache. However, it didn't.", (String)"test.cache.Name", (String)cache.getName());
        objectUnderTest.destroy();
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldReportTheMostDerivedObjectType() throws Exception {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setBeanName("test.bean.Name");
        objectUnderTest.afterPropertiesSet();
        AssertJUnit.assertEquals((String)"getObjectType() should have returned the most derived class of the actual Cache implementation returned from getObject(). However, it didn't.", objectUnderTest.getObject().getClass(), (Object)objectUnderTest.getObjectType());
        objectUnderTest.destroy();
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldProduceANonNullInfinispanCache() throws Exception {
        String cacheName = "test.cache.Name";
        String beanName = "test.bean.Name";
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName("test.cache.Name");
        objectUnderTest.setBeanName("test.bean.Name");
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"InfinispanNamedEmbeddedCacheFactoryBean should have produced a proper Infinispan cache. However, it produced a null Infinispan cache.", (Object)cache);
        objectUnderTest.destroy();
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldDeclareItselfToBeSingleton() {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        AssertJUnit.assertTrue((String)"InfinispanNamedEmbeddedCacheFactoryBean should declare itself to produce a singleton. However, it didn't.", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldStopTheCreatedInfinispanCacheWhenItIsDestroyed() throws Exception {
        String cacheName = "test.cache.Name";
        String beanName = "test.bean.Name";
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName("test.cache.Name");
        objectUnderTest.setBeanName("test.bean.Name");
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        objectUnderTest.destroy();
        AssertJUnit.assertEquals((String)"InfinispanNamedEmbeddedCacheFactoryBean should have stopped the created Infinispan cache when being destroyed. However, the created Infinispan is not yet terminated.", (Object)ComponentStatus.TERMINATED, (Object)cache.getStatus());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldRejectConfigurationTemplateModeNONEIfCacheConfigurationAlreadyExistsInConfigurationFile() throws Exception {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.PRECONFIGURED_DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName(CACHE_NAME_FROM_CONFIGURATION_FILE);
        objectUnderTest.setBeanName(CACHE_NAME_FROM_CONFIGURATION_FILE);
        objectUnderTest.setConfigurationTemplateMode("NONE");
        objectUnderTest.afterPropertiesSet();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void infinispanNamedEmbeddedCacheFactoryBeanShouldRejectConfigurationTemplateModeDEFAULTIfCacheConfigurationAlreadyExistsInConfigurationFile() throws Exception {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.PRECONFIGURED_DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName(CACHE_NAME_FROM_CONFIGURATION_FILE);
        objectUnderTest.setBeanName(CACHE_NAME_FROM_CONFIGURATION_FILE);
        objectUnderTest.setConfigurationTemplateMode("DEFAULT");
        objectUnderTest.afterPropertiesSet();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void infinispanNamedEmbeddedCacheFactoryShouldRejectConfigurationTemplateModeCUSTOM() throws Exception {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName(CACHE_NAME_FROM_CONFIGURATION_FILE);
        objectUnderTest.setConfigurationTemplateMode("CUSTOM");
        objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanNamedEmbeddedCacheFactoryShouldAcceptConfigurationTemplateModeCUSTOM() throws Exception {
        InfinispanNamedEmbeddedCacheFactoryBean objectUnderTest = new InfinispanNamedEmbeddedCacheFactoryBean();
        objectUnderTest.setInfinispanEmbeddedCacheManager(this.DEFAULT_CACHE_MANAGER);
        objectUnderTest.setCacheName(CACHE_NAME_FROM_CONFIGURATION_FILE);
        objectUnderTest.setConfigurationTemplateMode("CUSTOM");
        ConfigurationBuilder custom = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        objectUnderTest.addCustomConfiguration(custom);
        objectUnderTest.afterPropertiesSet();
    }
}

