/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.common.provider.NullValue;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.embedded.support.InfinispanNamedEmbeddedCacheFactoryBean;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.cache.Cache;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringCacheTest", groups={"unit", "smoke"})
public class SpringCacheTest
extends SingleCacheManagerTest {
    protected static final String CACHE_NAME = "testCache";
    private final InfinispanNamedEmbeddedCacheFactoryBean<Object, Object> fb = new InfinispanNamedEmbeddedCacheFactoryBean();
    private Cache<Object, Object> nativeCache;
    private org.springframework.cache.Cache cache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().defaultCacheName(CACHE_NAME), (ConfigurationBuilder)new ConfigurationBuilder());
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.nativeCache = this.createNativeCache();
        this.cache = this.createCache(this.nativeCache);
    }

    @Test
    public void testCacheName() throws Exception {
        AssertJUnit.assertEquals((String)CACHE_NAME, (String)this.cache.getName());
    }

    @Test
    public void testNativeCache() throws Exception {
        AssertJUnit.assertSame(this.nativeCache, (Object)this.cache.getNativeCache());
    }

    @Test
    public void testCachePut() throws Exception {
        String key = "enescu";
        String value = "george";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key).get());
    }

    @Test
    public void testCachePutSupportsNullValue() throws Exception {
        String key = "enescu";
        Object value = null;
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, value);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key).get());
    }

    @Test
    public void testCacheContains() throws Exception {
        String key = "enescu";
        String value = "george";
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertTrue((this.cache.get((Object)key) != null ? 1 : 0) != 0);
    }

    @Test
    public void testCacheContainsSupportsNullValue() throws Exception {
        String key = "enescu";
        Object value = null;
        this.cache.put((Object)key, value);
        AssertJUnit.assertTrue((this.cache.get((Object)key) != null ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingNullPointerExceptionOnNullGet() throws Exception {
        this.cache.get(null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingNullPointerExceptionOnNullGetWithClass() throws Exception {
        this.cache.get(null, (Class)null);
    }

    @Test
    public void testBypassingClassCheckWhenNullIsSpecified() throws Exception {
        this.cache.put((Object)"test", (Object)"test");
        Object value = this.cache.get((Object)"test", (Class)null);
        AssertJUnit.assertTrue((boolean)(value instanceof String));
    }

    @Test
    public void testReturningProperValueFromCacheWithCast() throws Exception {
        this.cache.put((Object)"test", (Object)"test");
        String value = (String)this.cache.get((Object)"test", String.class);
        AssertJUnit.assertEquals((String)"test", (String)value);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testThrowingIllegalStateExceptionWhenClassCastReturnDifferentClass() throws Exception {
        this.cache.put((Object)"test", new Object());
        this.cache.get((Object)"test", String.class);
    }

    @Test
    public void testReturningNullValueIfThereIsNoValue() throws Exception {
        Cache.ValueWrapper existingValue = this.cache.putIfAbsent((Object)"test", (Object)"test");
        AssertJUnit.assertNull((Object)existingValue);
    }

    @Test
    public void testReturningPreviousValue() throws Exception {
        this.cache.put((Object)"test", (Object)"test");
        Cache.ValueWrapper existingValue = this.cache.putIfAbsent((Object)"test", (Object)"test1");
        AssertJUnit.assertEquals((Object)"test", (Object)existingValue.get());
    }

    @Test
    public void testReturningNullValueConstant() throws Exception {
        this.cache.put((Object)"test", (Object)NullValue.NULL);
        Cache.ValueWrapper existingValue = this.cache.putIfAbsent((Object)"test", (Object)"test1");
        AssertJUnit.assertEquals((Object)NullValue.NULL, (Object)existingValue);
    }

    @Test
    public void testCacheClear() throws Exception {
        AssertJUnit.assertNull((Object)this.cache.get((Object)"enescu"));
        this.cache.put((Object)"enescu", (Object)"george");
        AssertJUnit.assertNull((Object)this.cache.get((Object)"vlaicu"));
        this.cache.put((Object)"vlaicu", (Object)"aurel");
        this.cache.clear();
        AssertJUnit.assertNull((Object)this.cache.get((Object)"vlaicu"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"enescu"));
    }

    @Test
    public void testValueLoaderWithNoPreviousValue() {
        this.cache.get((Object)"test", () -> "test");
        Cache.ValueWrapper valueFromCache = this.cache.get((Object)"test");
        AssertJUnit.assertEquals((Object)"test", (Object)valueFromCache.get());
    }

    @Test
    public void testValueLoaderWithLocking() throws Exception {
        CountDownLatch waitUntilThread1LocksValueGetter = new CountDownLatch(1);
        Future thread1 = this.fork(() -> (String)this.cache.get((Object)"test", () -> {
            waitUntilThread1LocksValueGetter.countDown();
            return "thread1";
        }));
        Future thread2 = this.fork(() -> {
            waitUntilThread1LocksValueGetter.await(30L, TimeUnit.SECONDS);
            return (String)this.cache.get((Object)"test", () -> "thread2");
        });
        String valueObtainedByThread1 = (String)thread1.get();
        String valueObtainedByThread2 = (String)thread2.get();
        Cache.ValueWrapper valueAfterGetterIsDone = this.cache.get((Object)"test");
        AssertJUnit.assertNotNull((Object)valueAfterGetterIsDone);
        AssertJUnit.assertEquals((Object)"thread1", (Object)valueAfterGetterIsDone.get());
        AssertJUnit.assertEquals((String)"thread1", (String)valueObtainedByThread1);
        AssertJUnit.assertEquals((String)"thread1", (String)valueObtainedByThread2);
    }

    @Test
    public void testValueLoaderWithPreviousValue() {
        this.cache.put((Object)"test", (Object)"test");
        this.cache.get((Object)"test", () -> "This should not be updated");
        Cache.ValueWrapper valueFromCache = this.cache.get((Object)"test");
        AssertJUnit.assertEquals((Object)"test", (Object)valueFromCache.get());
    }

    @Test(expectedExceptions={Cache.ValueRetrievalException.class})
    public void testValueLoaderWithExceptionWhenLoading() {
        this.cache.get((Object)"test", () -> {
            throw new IllegalStateException();
        });
    }

    @Test
    public void testPutNullAndGetWithClass() {
        this.cache.put((Object)"key", null);
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key", String.class));
    }

    @Test
    public void testGetWithNullValue() {
        AssertJUnit.assertNull((Object)this.cache.get((Object)"null", () -> null));
    }

    @Test
    public void testGetNullValueAfterPutNull() {
        this.cache.put((Object)"key", null);
        String result = (String)this.cache.get((Object)"key", () -> "notnull");
        AssertJUnit.assertNull((Object)result);
    }

    private Cache<Object, Object> createNativeCache() throws Exception {
        this.fb.setInfinispanEmbeddedCacheManager(this.cacheManager);
        this.fb.setBeanName(CACHE_NAME);
        this.fb.setCacheName(CACHE_NAME);
        this.fb.afterPropertiesSet();
        return this.fb.getObject();
    }

    private org.springframework.cache.Cache createCache(Cache<Object, Object> nativeCache) {
        return new SpringCache(nativeCache);
    }
}

