/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.embedded.provider.SpringEmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.embedded.provider.SpringEmbeddedCacheManagerTest", groups={"unit"})
public class SpringEmbeddedCacheManagerTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void springEmbeddedCacheManagerConstructorShouldRejectNullEmbeddedCacheManager() {
        new SpringEmbeddedCacheManager(null);
    }

    @Test
    public final void getCacheShouldReturnTheCacheHavingTheProvidedName() throws IOException {
        EmbeddedCacheManager nativeCacheManager = TestCacheManagerFactory.fromStream((InputStream)SpringEmbeddedCacheManagerTest.class.getResourceAsStream(NAMED_ASYNC_CACHE_CONFIG_LOCATION));
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager(nativeCacheManager);
        SpringCache cacheExpectedToHaveTheProvidedName = objectUnderTest.getCache(CACHE_NAME_FROM_CONFIGURATION_FILE);
        AssertJUnit.assertEquals((String)"getCache(asyncCache) should have returned the cache having the provided name. However, the cache returned has a different name.", (String)CACHE_NAME_FROM_CONFIGURATION_FILE, (String)cacheExpectedToHaveTheProvidedName.getName());
        nativeCacheManager.stop();
    }

    @Test
    public final void getCacheShouldReturnACacheAddedAfterCreatingTheSpringEmbeddedCache() throws IOException {
        String nameOfInfinispanCacheAddedLater = "infinispan.cache.addedLater";
        EmbeddedCacheManager nativeCacheManager = TestCacheManagerFactory.fromStream((InputStream)SpringEmbeddedCacheManagerTest.class.getResourceAsStream(NAMED_ASYNC_CACHE_CONFIG_LOCATION));
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager(nativeCacheManager);
        nativeCacheManager.defineConfiguration("infinispan.cache.addedLater", nativeCacheManager.getDefaultCacheConfiguration());
        Cache infinispanCacheAddedLater = nativeCacheManager.getCache("infinispan.cache.addedLater");
        SpringCache springCacheAddedLater = objectUnderTest.getCache("infinispan.cache.addedLater");
        AssertJUnit.assertEquals((String)"getCache(infinispan.cache.addedLater) should have returned the Spring cache having the Infinispan cache added after creating SpringEmbeddedCacheManager as its underlying native cache. However, the underlying native cache is different.", (Object)infinispanCacheAddedLater, (Object)springCacheAddedLater.getNativeCache());
        nativeCacheManager.stop();
    }

    @Test
    public final void getCacheNamesShouldReturnAllCachesDefinedInConfigurationFile() throws IOException {
        EmbeddedCacheManager nativeCacheManager = TestCacheManagerFactory.fromStream((InputStream)SpringEmbeddedCacheManagerTest.class.getResourceAsStream(NAMED_ASYNC_CACHE_CONFIG_LOCATION));
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager(nativeCacheManager);
        Collection cacheNames = objectUnderTest.getCacheNames();
        AssertJUnit.assertTrue((String)"SpringEmbeddedCacheManager should load all named caches found in the configuration file of the wrapped native cache manager. However, it does not know about the cache named asyncCache defined in said configuration file.", (boolean)cacheNames.contains(CACHE_NAME_FROM_CONFIGURATION_FILE));
        nativeCacheManager.stop();
    }

    @Test
    public final void stopShouldStopTheNativeEmbeddedCacheManager() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            public void call() {
                this.cm.getCache();
                SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager(this.cm);
                objectUnderTest.stop();
                AssertJUnit.assertEquals((String)"Calling stop() on SpringEmbeddedCacheManager should stop the enclosed Infinispan EmbeddedCacheManager. However, it is still running.", (Object)ComponentStatus.TERMINATED, (Object)this.cm.getStatus());
            }
        });
    }

    @Test
    public final void getNativeCacheShouldReturnTheEmbeddedCacheManagerSuppliedAtConstructionTime() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            public void call() {
                SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager(this.cm);
                EmbeddedCacheManager nativeCacheManagerReturned = objectUnderTest.getNativeCacheManager();
                AssertJUnit.assertSame((String)"getNativeCacheManager() should have returned the EmbeddedCacheManager supplied at construction time. However, it retuned a different one.", (Object)this.cm, (Object)nativeCacheManagerReturned);
            }
        });
    }
}

