/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.support;

import org.infinispan.Cache;
import org.infinispan.spring.common.InfinispanTestExecutionListener;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/embedded/support/InfinispanDefaultCacheFactoryBeanContextTest.xml"})
@Test(testName="spring.embedded.support.InfinispanDefaultCacheFactoryBeanContextTest", groups={"unit"})
@TestExecutionListeners(value={InfinispanTestExecutionListener.class})
public class InfinispanDefaultCacheFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String DEFAULT_CACHE_NAME = "testDefaultCache";

    @Test
    public final void shouldProduceANonNullCache() {
        Cache testDefaultCache = (Cache)this.applicationContext.getBean(DEFAULT_CACHE_NAME, Cache.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain an Infinispan cache under the bean name \"testDefaultCache\". However, it doesn't.", (Object)testDefaultCache);
    }

    @Test
    public final void shouldAlwaysReturnTheSameCache() {
        Cache testDefaultCache1 = (Cache)this.applicationContext.getBean(DEFAULT_CACHE_NAME, Cache.class);
        Cache testDefaultCache2 = (Cache)this.applicationContext.getBean(DEFAULT_CACHE_NAME, Cache.class);
        AssertJUnit.assertSame((String)"InfinispanDefaultCacheFactoryBean should always return the same cache instance when being called repeatedly. However, the cache instances are not the same.", (Object)testDefaultCache1, (Object)testDefaultCache2);
    }
}

