/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.SomeRequestBalancingStrategy;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.spring.remote.AssertionUtils;
import org.infinispan.spring.remote.provider.SpringRemoteCacheManager;
import org.infinispan.spring.remote.provider.SpringRemoteCacheManagerFactoryBean;
import org.infinispan.test.AbstractInfinispanTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="spring.remote.provider.SpringRemoteCacheManagerFactoryBeanTest", groups={"unit"})
public class SpringRemoteCacheManagerFactoryBeanTest
extends AbstractInfinispanTest {
    private static final Resource HOTROD_CLIENT_PROPERTIES_LOCATION = new ClassPathResource("hotrod-client.properties", SpringRemoteCacheManagerFactoryBeanTest.class);
    private SpringRemoteCacheManagerFactoryBean objectUnderTest;

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        if (this.objectUnderTest != null) {
            this.objectUnderTest.destroy();
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void shouldThrowAnIllegalStateExceptionIfBothConfigurationPropertiesAndConfifurationPropertiesFileLocationAreSet() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setConfigurationProperties(new Properties());
        this.objectUnderTest.setConfigurationPropertiesFileLocation((Resource)new ClassPathResource("dummy", ((Object)((Object)this)).getClass()));
        this.objectUnderTest.afterPropertiesSet();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void shouldThrowAnIllegalStateExceptionIfConfigurationPropertiesAsWellAsSettersAreUsedToConfigureTheRemoteCacheManager() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setConfigurationProperties(new Properties());
        this.objectUnderTest.setTransportFactory("test.TransportFactory");
        this.objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanRemoteCacheFactoryBeanShouldReportTheMostDerivedObjectType() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.afterPropertiesSet();
        AssertJUnit.assertEquals((String)"getObjectType() should have returned the most derived class of the actual RemoteCache implementation returned from getObject(). However, it didn't.", this.objectUnderTest.getObject().getClass(), (Object)this.objectUnderTest.getObjectType());
    }

    @Test
    public final void shouldProduceARemoteCacheManagerConfiguredUsingDefaultSettingsIfNeitherConfigurationPropertiesNorConfigurationPropertiesFileLocationHasBeenSet() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        RemoteCacheManager defaultRemoteCacheManager = new RemoteCacheManager();
        try {
            AssertionUtils.assertPropertiesSubset("The configuration properties used by the SpringRemoteCacheManager returned von getObject() should be equal to SpringRemoteCacheManager's default settings since neither property 'configurationProperties' nor property 'configurationPropertiesFileLocation' has been set. However, those two are not equal.", defaultRemoteCacheManager.getConfiguration().properties(), remoteCacheManager.getNativeCacheManager().getConfiguration().properties());
        }
        finally {
            defaultRemoteCacheManager.stop();
        }
    }

    @Test
    public final void isSingletonShouldAlwaysReturnTrue() {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true since each SpringRemoteCacheManagerFactoryBean will always produce the same SpringRemoteCacheManager instance. However,it returned false.", (boolean)this.objectUnderTest.isSingleton());
    }

    @Test
    public final void destroyShouldStopTheProducedCache() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        this.objectUnderTest.destroy();
        AssertJUnit.assertFalse((String)"destroy() should have stopped the SpringRemoteCacheManager instance previously produced by SpringRemoteCacheManagerFactoryBean. However, the produced SpringRemoteCacheManager is still running. ", (boolean)remoteCacheManager.getNativeCacheManager().isStarted());
    }

    @Test
    public final void shouldProduceACacheConfiguredUsingTheSuppliedConfigurationProperties() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        Properties configurationProperties = this.loadConfigurationProperties(HOTROD_CLIENT_PROPERTIES_LOCATION);
        this.objectUnderTest.setConfigurationProperties(configurationProperties);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the SpringRemoteCacheManager returned von getObject() should be equal to those passed into SpringRemoteCacheManagerFactoryBean via setConfigurationProperties(props). However, those two are not equal.", configurationProperties, remoteCacheManager.getNativeCacheManager().getConfiguration().properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigurationProperties(Resource configurationPropertiesLocation) throws IOException {
        try (InputStream propsStream = null;){
            propsStream = HOTROD_CLIENT_PROPERTIES_LOCATION.getInputStream();
            Properties configurationProperties = new Properties();
            configurationProperties.load(propsStream);
            Properties properties = configurationProperties;
            return properties;
        }
    }

    @Test
    public final void shouldProduceACacheConfiguredUsingPropertiesLoadedFromALocationDeclaredThroughSetConfigurationPropertiesFileLocation() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setConfigurationPropertiesFileLocation(HOTROD_CLIENT_PROPERTIES_LOCATION);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the SpringRemoteCacheManager returned von getObject() should be equal to those passed into SpringRemoteCacheManagerFactoryBean via setConfigurationPropertiesFileLocation(propsFileLocation). However, those two are not equal.", this.loadConfigurationProperties(HOTROD_CLIENT_PROPERTIES_LOCATION), remoteCacheManager.getNativeCacheManager().getConfiguration().properties());
    }

    @Test
    public final void shouldProduceAStoppedCacheIfStartAutomaticallyIsSetToFalse() throws Exception {
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setStartAutomatically(false);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManagerExpectedToBeInStateStopped = this.objectUnderTest.getObject();
        AssertJUnit.assertFalse((String)"SpringRemoteCacheManagerFactoryBean should have produced a SpringRemoteCacheManager that is initially in state stopped since property 'startAutomatically' has been set to false. However, the produced SpringRemoteCacheManager is already started.", (boolean)remoteCacheManagerExpectedToBeInStateStopped.getNativeCacheManager().isStarted());
    }

    @Test
    public final void setServerListShouldOverrideDefaultServerList() throws Exception {
        ArrayList<InetSocketAddress> expectedServerList = new ArrayList<InetSocketAddress>(1);
        expectedServerList.add(new InetSocketAddress("testhost", 4632));
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        String expectedServerListString = "testhost:4632";
        this.objectUnderTest.setServerList(expectedServerList);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setServerList(" + expectedServerList + ") should have overridden property 'serverList'. However, it didn't."), (Object)"testhost:4632", (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.server_list"));
    }

    @Test
    public final void setMarshallerShouldOverrideDefaultMarshaller() throws Exception {
        String expectedMarshaller = Marshaller.class.getName();
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setMarshaller(expectedMarshaller);
        this.objectUnderTest.setStartAutomatically(false);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setMarshaller(" + expectedMarshaller + ") should have overridden property 'marshaller'. However, it didn't."), (Object)expectedMarshaller, (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.marshaller"));
    }

    @Test
    public final void setAsyncExecutorFactoryShouldOverrideDefaultAsyncExecutorFactory() throws Exception {
        String expectedAsyncExecutorFactory = ExecutorFactory.class.getName();
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setAsyncExecutorFactory(expectedAsyncExecutorFactory);
        this.objectUnderTest.setStartAutomatically(false);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setAsyncExecutorFactory(" + expectedAsyncExecutorFactory + ") should have overridden property 'asyncExecutorFactory'. However, it didn't."), (Object)expectedAsyncExecutorFactory, (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.async_executor_factory"));
    }

    @Test
    public final void setTcpNoDelayShouldOverrideDefaultTcpNoDelay() throws Exception {
        boolean expectedTcpNoDelay = true;
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setTcpNoDelay(true);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setTcpNoDelay(true) should have overridden property 'tcpNoDelay'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.tcp_no_delay"));
    }

    @Test
    public final void setTcpKeepAliveOverrideDefaultTcpKeepAlive() throws Exception {
        boolean expectedTcpKeepAlive = false;
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setTcpKeepAlive(false);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setTcpKeepAlive(false) should have overridden property 'tcpKeepAlive'. However, it didn't.", (Object)String.valueOf(false), (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.tcp_keep_alive"));
    }

    @Test
    public final void setRequestBalancingStrategyShouldOverrideDefaultRequestBalancingStrategy() throws Exception {
        String expectedRequestBalancingStrategy = SomeRequestBalancingStrategy.class.getName();
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setRequestBalancingStrategy(expectedRequestBalancingStrategy);
        this.objectUnderTest.setStartAutomatically(false);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setRequestBalancingStrategy(" + expectedRequestBalancingStrategy + ") should have overridden property 'requestBalancingStrategy'. However, it didn't."), (Object)expectedRequestBalancingStrategy, (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.request_balancing_strategy"));
    }

    @Test
    public final void setKeySizeEstimateShouldOverrideDefaultKeySizeEstimate() throws Exception {
        int expectedKeySizeEstimate = -123456;
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setKeySizeEstimate(-123456);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setKeySizeEstimate(-123456) should have overridden property 'keySizeEstimate'. However, it didn't.", (Object)String.valueOf(-123456), (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.key_size_estimate"));
    }

    @Test
    public final void setValueSizeEstimateShouldOverrideDefaultValueSizeEstimate() throws Exception {
        int expectedValueSizeEstimate = -3456789;
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setValueSizeEstimate(-3456789);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setValueSizeEstimate(-3456789) should have overridden property 'valueSizeEstimate'. However, it didn't.", (Object)String.valueOf(-3456789), (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.value_size_estimate"));
    }

    @Test
    public final void setForceReturnValuesShouldOverrideDefaultForceReturnValues() throws Exception {
        boolean expectedForceReturnValues = true;
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setForceReturnValues(true);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setForceReturnValue(true) should have overridden property 'forceReturnValue'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getNativeCacheManager().getConfiguration().properties().get("infinispan.client.hotrod.force_return_values"));
    }

    @Test
    public final void setReadTimeoutShouldOverrideDefaultReadTimeout() throws Exception {
        long expectedReadTimeout = 500L;
        this.objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        this.objectUnderTest.setReadTimeout(500L);
        this.objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = this.objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setReadTimeout(500) should have overridden property 'readTimeout'. However, it didn't.", (long)500L, (long)remoteCacheManager.getReadTimeout());
    }
}

