/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.SomeRequestBalancingStrategy;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.spring.remote.AssertionUtils;
import org.infinispan.spring.remote.support.InfinispanRemoteCacheManagerFactoryBean;
import org.infinispan.test.AbstractInfinispanTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.remote.support.InfinispanRemoteCacheManagerFactoryBeanTest", groups={"unit"})
public class InfinispanRemoteCacheManagerFactoryBeanTest
extends AbstractInfinispanTest {
    private static final Resource HOTROD_CLIENT_PROPERTIES_LOCATION = new ClassPathResource("hotrod-client.properties", InfinispanRemoteCacheManagerFactoryBeanTest.class);

    @Test(expectedExceptions={IllegalStateException.class})
    public final void shouldThrowAnIllegalStateExceptionIfBothConfigurationPropertiesAndConfigurationPropertiesFileLocationAreSet() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setConfigurationProperties(new Properties());
        objectUnderTest.setConfigurationPropertiesFileLocation((Resource)new ClassPathResource("dummy", ((Object)((Object)this)).getClass()));
        objectUnderTest.afterPropertiesSet();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void shouldThrowAnIllegalStateExceptionIfConfigurationPropertiesAsWellAsSettersAreUsedToConfigureTheRemoteCacheManager() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setConfigurationProperties(new Properties());
        objectUnderTest.setMarshaller("test.Marshaller");
        objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanRemoteCacheFactoryBeanShouldReportTheMostDerivedObjectType() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        AssertJUnit.assertEquals((String)"getObjectType() should have returned the most derived class of the actual RemoteCache implementation returned from getObject(). However, it didn't.", objectUnderTest.getObject().getClass(), (Object)objectUnderTest.getObjectType());
        objectUnderTest.destroy();
    }

    @Test
    public final void shouldProduceARemoteCacheManagerConfiguredUsingDefaultSettingsIfNeitherConfigurationPropertiesNorConfigurationPropertiesFileLocationHasBeenSet() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager springRemoteCacheManager = objectUnderTest.getObject();
        RemoteCacheManager defaultRemoteCacheManager = new RemoteCacheManager();
        Properties clientDefaultProps = defaultRemoteCacheManager.getConfiguration().properties();
        clientDefaultProps.setProperty("infinispan.client.hotrod.marshaller", JavaSerializationMarshaller.class.getName());
        clientDefaultProps.setProperty("infinispan.client.hotrod.java_serial_whitelist", "java.util.HashMap,java.time.*,org.springframework.*,org.infinispan.spring.remote.*");
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the RemoteCacheManager returned by getObject() should be equal to RemoteCacheManager's default settings since neither property 'configurationProperties' nor property 'configurationPropertiesFileLocation' has been set. However, those two are not equal.", clientDefaultProps, springRemoteCacheManager.getConfiguration().properties());
        objectUnderTest.destroy();
        defaultRemoteCacheManager.stop();
    }

    @Test
    public final void isSingletonShouldAlwaysReturnTrue() {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true since each AbstractRemoteCacheManagerFactory will always produce the same RemoteCacheManager instance. However,it returned false.", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void destroyShouldStopTheProducedCache() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        objectUnderTest.destroy();
        AssertJUnit.assertFalse((String)"destroy() should have stopped the RemoteCacheManager instance previously produced by AbstractRemoteCacheManagerFactory. However, the produced RemoteCacheManager is still running. ", (boolean)remoteCacheManager.isStarted());
    }

    @Test
    public final void shouldProduceACacheConfiguredUsingTheSuppliedConfigurationProperties() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        Properties configurationProperties = this.loadConfigurationProperties(HOTROD_CLIENT_PROPERTIES_LOCATION);
        objectUnderTest.setConfigurationProperties(configurationProperties);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the RemoteCacheManager returned by getObject() should be equal to those passed into InfinispanRemoteCacheMangerFactoryBean via setConfigurationProperties(props). However, those two are not equal.", configurationProperties, remoteCacheManager.getConfiguration().properties());
        objectUnderTest.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigurationProperties(Resource configurationPropertiesLocation) throws IOException {
        try (InputStream propsStream = null;){
            propsStream = HOTROD_CLIENT_PROPERTIES_LOCATION.getInputStream();
            Properties configurationProperties = new Properties();
            configurationProperties.load(propsStream);
            Properties properties = configurationProperties;
            return properties;
        }
    }

    @Test
    public final void shouldProduceACacheConfiguredUsingPropertiesLoadedFromALocationDeclaredThroughSetConfigurationPropertiesFileLocation() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setConfigurationPropertiesFileLocation(HOTROD_CLIENT_PROPERTIES_LOCATION);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the RemoteCacheManager returned by getObject() should be equal to those passed into InfinispanRemoteCacheMangerFactoryBean via setConfigurationPropertiesFileLocation(propsFileLocation). However, those two are not equal.", this.loadConfigurationProperties(HOTROD_CLIENT_PROPERTIES_LOCATION), remoteCacheManager.getConfiguration().properties());
        objectUnderTest.destroy();
    }

    @Test
    public final void shouldProduceAStoppedCacheIfStartAutomaticallyIsSetToFalse() throws Exception {
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManagerExpectedToBeInStateStopped = objectUnderTest.getObject();
        AssertJUnit.assertFalse((String)"AbstractRemoteCacheManagerFactory should have produced a RemoteCacheManager that is initially in state stopped since property 'startAutomatically' has been set to false. However, the produced RemoteCacheManager is already started.", (boolean)remoteCacheManagerExpectedToBeInStateStopped.isStarted());
        objectUnderTest.destroy();
    }

    @Test
    public final void setServerListShouldOverrideDefaultServerList() throws Exception {
        ArrayList<InetSocketAddress> expectedServerList = new ArrayList<InetSocketAddress>(1);
        expectedServerList.add(new InetSocketAddress("testhost", 4632));
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        String expectedServerListString = "testhost:4632";
        objectUnderTest.setServerList(expectedServerList);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setServerList(" + expectedServerList + ") should have overridden property 'serverList'. However, it didn't."), (Object)"testhost:4632", (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.server_list"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setMarshallerShouldOverrideDefaultMarshaller() throws Exception {
        String expectedMarshaller = Marshaller.class.getName();
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setMarshaller(expectedMarshaller);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setMarshaller(" + expectedMarshaller + ") should have overridden property 'marshaller'. However, it didn't."), (Object)expectedMarshaller, (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.marshaller"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setAsyncExecutorFactoryShouldOverrideDefaultAsyncExecutorFactory() throws Exception {
        String expectedAsyncExecutorFactory = ExecutorFactory.class.getName();
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setAsyncExecutorFactory(expectedAsyncExecutorFactory);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setAsyncExecutorFactory(" + expectedAsyncExecutorFactory + ") should have overridden property 'asyncExecutorFactory'. However, it didn't."), (Object)expectedAsyncExecutorFactory, (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.async_executor_factory"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setTcpNoDelayShouldOverrideDefaultTcpNoDelay() throws Exception {
        boolean expectedTcpNoDelay = true;
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setTcpNoDelay(true);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setTcpNoDelay(true) should have overridden property 'tcpNoDelay'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.tcp_no_delay"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setTcpKeepAliveShouldOverrideDefaultTcpKeepAlive() throws Exception {
        boolean expectedTcpKeepAlive = false;
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setTcpNoDelay(false);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setTcpKeepAlive(false) should have overridden property 'tcpNoDelay'. However, it didn't.", (Object)String.valueOf(false), (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.tcp_keep_alive"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setRequestBalancingStrategyShouldOverrideDefaultRequestBalancingStrategy() throws Exception {
        String expectedRequestBalancingStrategy = SomeRequestBalancingStrategy.class.getName();
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setRequestBalancingStrategy(expectedRequestBalancingStrategy);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setRequestBalancingStrategy(" + expectedRequestBalancingStrategy + ") should have overridden property 'requestBalancingStrategy'. However, it didn't."), (Object)expectedRequestBalancingStrategy, (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.request_balancing_strategy"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setKeySizeEstimateShouldOverrideDefaultKeySizeEstimate() throws Exception {
        int expectedKeySizeEstimate = -123456;
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setKeySizeEstimate(-123456);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setKeySizeEstimate(-123456) should have overridden property 'keySizeEstimate'. However, it didn't.", (Object)String.valueOf(-123456), (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.key_size_estimate"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setValueSizeEstimateShouldOverrideDefaultValueSizeEstimate() throws Exception {
        int expectedValueSizeEstimate = -3456789;
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setValueSizeEstimate(-3456789);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setValueSizeEstimate(-3456789) should have overridden property 'valueSizeEstimate'. However, it didn't.", (Object)String.valueOf(-3456789), (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.value_size_estimate"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setForceReturnValuesShouldOverrideDefaultForceReturnValues() throws Exception {
        boolean expectedForceReturnValues = true;
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setForceReturnValues(true);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setForceReturnValue(true) should have overridden property 'forceReturnValue'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.force_return_values"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setNearCacheModeShouldOverrideDefaultNearCacheMode() throws Exception {
        NearCacheMode expectedNearCacheMode = NearCacheMode.INVALIDATED;
        InfinispanRemoteCacheManagerFactoryBean objectUnderTest = new InfinispanRemoteCacheManagerFactoryBean();
        objectUnderTest.setNearCacheMode(expectedNearCacheMode.name());
        objectUnderTest.setNearCacheMaxEntries(100);
        objectUnderTest.afterPropertiesSet();
        RemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setNearCacheMode(" + expectedNearCacheMode + ") should have overridden property 'nearCacheMode'. However, it didn't."), (Object)expectedNearCacheMode.name(), (Object)remoteCacheManager.getConfiguration().properties().get("infinispan.client.hotrod.near_cache.mode"));
        objectUnderTest.destroy();
    }
}

