/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.InfinispanApplicationPublishedBridgeTCK;
import org.infinispan.spring.remote.session.InfinispanRemoteSessionRepository;
import org.infinispan.spring.remote.session.RemoteApplicationPublishedBridge;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.KeyValuePair;
import org.springframework.session.MapSession;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.session.RemoteApplicationPublishedBridgeTest", groups={"unit"})
public class RemoteApplicationPublishedBridgeTest
extends InfinispanApplicationPublishedBridgeTCK {
    private EmbeddedCacheManager embeddedCacheManager;
    private HotRodServer hotrodServer;
    private RemoteCacheManager remoteCacheManager;

    @BeforeClass
    public void beforeClass() {
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.embeddedCacheManager, (int)19723);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue()).marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialWhiteList("java.util.HashMap,java.time.*,org.springframework.*,org.infinispan.spring.remote.*".split(","));
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterMethod
    public void afterMethod() {
        this.remoteCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.embeddedCacheManager.stop();
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.remoteCacheManager.getCache());
    }

    protected void callEviction() {
        this.embeddedCacheManager.getCache().getAdvancedCache().getExpirationManager().processExpiration();
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) {
        InfinispanRemoteSessionRepository sessionRepository = new InfinispanRemoteSessionRepository(springCache);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    public void testEventBridge() throws Exception {
        super.testEventBridge();
    }

    public void testUnregistration() throws Exception {
        super.testUnregistration();
    }

    public void testReadEventWithoutValue() {
        RemoteApplicationPublishedBridge remoteApplicationPublishedBridge = new RemoteApplicationPublishedBridge(this.createSpringCache());
        String id = "1234";
        TestEvent event = new TestEvent(id);
        KeyValuePair keyValuePair = remoteApplicationPublishedBridge.readEvent((ClientCacheEntryCustomEvent)event);
        AssertJUnit.assertEquals((String)id, (String)((String)keyValuePair.getKey()));
        AssertJUnit.assertNotNull((Object)keyValuePair.getValue());
        MapSession value = (MapSession)keyValuePair.getValue();
        AssertJUnit.assertEquals((String)id, (String)value.getId());
    }

    public void testEventBridgeWithSessionIdChange() throws Exception {
        super.testEventBridgeWithSessionIdChange();
    }

    class TestEvent
    implements ClientCacheEntryCustomEvent<byte[]> {
        private String sessionId;

        public TestEvent(String sessionId) {
            this.sessionId = sessionId;
        }

        public byte[] getEventData() {
            RemoteCache cache = RemoteApplicationPublishedBridgeTest.this.remoteCacheManager.getCache();
            int keySizeEstimate = cache.getRemoteCacheManager().getConfiguration().keySizeEstimate();
            int valueSizeEstimate = cache.getRemoteCacheManager().getConfiguration().valueSizeEstimate();
            byte[] key = cache.getDataFormat().keyToBytes((Object)this.sessionId, keySizeEstimate, valueSizeEstimate);
            int capacity = UnsignedNumeric.sizeUnsignedInt((int)key.length) + key.length;
            byte[] out = new byte[capacity];
            int offset = UnsignedNumeric.writeUnsignedInt((byte[])out, (int)0, (int)key.length);
            System.arraycopy(key, 0, out, offset, key.length);
            return out;
        }

        public boolean isCommandRetried() {
            return false;
        }

        public ClientEvent.Type getType() {
            return null;
        }
    }
}

