/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.provider;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.spring.common.provider.NullValue;
import org.infinispan.spring.common.provider.PersistenceContextInitializerImpl;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.MapSessionProtoAdapter;
import org.springframework.cache.CacheManager;
import org.springframework.session.MapSession;
import org.springframework.util.Assert;

public class SpringRemoteCacheManager
implements CacheManager {
    private final RemoteCacheManager nativeCacheManager;
    private final ConcurrentMap<String, SpringCache> springCaches = new ConcurrentHashMap<String, SpringCache>();
    private volatile long readTimeout;
    private volatile long writeTimeout;

    public SpringRemoteCacheManager(RemoteCacheManager nativeCacheManager, long readTimeout, long writeTimeout) {
        Assert.notNull((Object)nativeCacheManager, (String)"A non-null instance of EmbeddedCacheManager needs to be supplied");
        this.nativeCacheManager = nativeCacheManager;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.configureMarshallers(nativeCacheManager);
    }

    public SpringRemoteCacheManager(RemoteCacheManager nativeCacheManager) {
        this(nativeCacheManager, 0L, 0L);
    }

    public SpringCache getCache(String name) {
        RemoteCache nativeCache = this.nativeCacheManager.getCache(name);
        if (nativeCache == null) {
            this.springCaches.remove(name);
            return null;
        }
        return this.springCaches.computeIfAbsent(name, n -> new SpringCache((BasicCache)nativeCache, this.readTimeout, this.writeTimeout));
    }

    public Collection<String> getCacheNames() {
        return this.nativeCacheManager.getCacheNames();
    }

    public RemoteCacheManager getNativeCacheManager() {
        return this.nativeCacheManager;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void start() {
        this.nativeCacheManager.start();
    }

    public void stop() {
        this.nativeCacheManager.stop();
        this.springCaches.clear();
    }

    private void configureMarshallers(RemoteCacheManager nativeCacheManager) {
        SerializationContext ctx;
        MarshallerRegistry marshallerRegistry = nativeCacheManager.getMarshallerRegistry();
        JavaSerializationMarshaller serializationMarshaller = (JavaSerializationMarshaller)marshallerRegistry.getMarshaller(MediaType.APPLICATION_SERIALIZED_OBJECT);
        if (serializationMarshaller == null) {
            serializationMarshaller = new JavaSerializationMarshaller();
            marshallerRegistry.registerMarshaller((Marshaller)serializationMarshaller);
        }
        ClassAllowList serializationAllowList = new ClassAllowList();
        serializationAllowList.addClasses(new Class[]{NullValue.class});
        serializationAllowList.addRegexps(new String[]{"java.util\\..*", "org.springframework\\..*"});
        serializationMarshaller.initialize(serializationAllowList);
        ProtoStreamMarshaller protoMarshaller = (ProtoStreamMarshaller)marshallerRegistry.getMarshaller(MediaType.APPLICATION_PROTOSTREAM);
        if (protoMarshaller == null) {
            try {
                protoMarshaller = new ProtoStreamMarshaller();
                marshallerRegistry.registerMarshaller((Marshaller)protoMarshaller);
                ctx = protoMarshaller.getSerializationContext();
                for (SerializationContextInitializer sci : nativeCacheManager.getConfiguration().getContextInitializers()) {
                    sci.registerSchema(ctx);
                    sci.registerMarshallers(ctx);
                }
            }
            catch (NoClassDefFoundError ctx2) {
                // empty catch block
            }
        }
        if (protoMarshaller != null) {
            ctx = protoMarshaller.getSerializationContext();
            this.addProviderContextInitializer(ctx);
            this.addSessionContextInitializerAndMarshaller(ctx, serializationMarshaller);
        }
    }

    private void addProviderContextInitializer(SerializationContext ctx) {
        PersistenceContextInitializerImpl providerSci = new PersistenceContextInitializerImpl();
        providerSci.registerMarshallers(ctx);
        providerSci.registerSchema(ctx);
    }

    private void addSessionContextInitializerAndMarshaller(SerializationContext ctx, JavaSerializationMarshaller serializationMarshaller) {
        try {
            new MapSession();
        }
        catch (NoClassDefFoundError e) {
            Log.CONFIG.debug((Object)"spring-session classes not found, skipping the session context initializer registration");
            return;
        }
        org.infinispan.spring.common.session.PersistenceContextInitializerImpl sessionSci = new org.infinispan.spring.common.session.PersistenceContextInitializerImpl();
        sessionSci.registerMarshallers(ctx);
        sessionSci.registerSchema(ctx);
        MapSessionProtoAdapter.SessionAttributeRawMarshaller sessionAttributeMarshaller = new MapSessionProtoAdapter.SessionAttributeRawMarshaller(serializationMarshaller);
        ctx.registerMarshaller((BaseMarshaller)sessionAttributeMarshaller);
    }
}

