/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.provider;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.remote.provider.SpringRemoteCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.cache.Cache;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringRemoteCacheTest", groups={"functional"})
public class SpringRemoteCacheTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = "SerializationCache";
    private static final String TEST_CACHE_NAME_PROTO = "ProtoStreamCache";
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_SERIALIZED_OBJECT).build());
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME_PROTO, HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_PROTOSTREAM).build());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        return this.cacheManager;
    }

    @BeforeClass
    public void setupRemoteCacheFactory() {
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)0);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        builder.remoteCache(TEST_CACHE_NAME).marshaller(JavaSerializationMarshaller.class);
        builder.remoteCache(TEST_CACHE_NAME_PROTO).marshaller(ProtoStreamMarshaller.class);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterClass
    public void destroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @Test(timeOut=30000L)
    public void testValueLoaderWithLocking() throws Exception {
        SpringRemoteCacheManager springRemoteCacheManager = new SpringRemoteCacheManager(this.remoteCacheManager);
        SpringCache cache = springRemoteCacheManager.getCache(TEST_CACHE_NAME);
        CountDownLatch waitUntilThread1LocksValueGetter = new CountDownLatch(1);
        Future thread1 = this.fork(() -> (String)cache.get((Object)"test", () -> {
            waitUntilThread1LocksValueGetter.countDown();
            return "thread1";
        }));
        Future thread2 = this.fork(() -> {
            waitUntilThread1LocksValueGetter.await();
            return (String)cache.get((Object)"test", () -> "thread2");
        });
        String valueObtainedByThread1 = (String)thread1.get();
        String valueObtainedByThread2 = (String)thread2.get();
        Cache.ValueWrapper valueAfterGetterIsDone = cache.get((Object)"test");
        AssertJUnit.assertNotNull((Object)valueAfterGetterIsDone);
        AssertJUnit.assertEquals((Object)"thread1", (Object)valueAfterGetterIsDone.get());
        AssertJUnit.assertEquals((String)"thread1", (String)valueObtainedByThread1);
        AssertJUnit.assertEquals((String)"thread1", (String)valueObtainedByThread2);
    }

    @DataProvider(name="caches")
    public Object[][] caches() {
        return new Object[][]{{TEST_CACHE_NAME}, {TEST_CACHE_NAME_PROTO}};
    }

    @Test(dataProvider="caches")
    public void testNullValues(String cacheName) {
        SpringRemoteCacheManager springRemoteCacheManager = new SpringRemoteCacheManager(this.remoteCacheManager);
        SpringCache cache = springRemoteCacheManager.getCache(cacheName);
        cache.put((Object)"key", null);
        Cache.ValueWrapper valueWrapper = cache.get((Object)"key");
        AssertJUnit.assertNotNull((Object)valueWrapper);
        AssertJUnit.assertNull((Object)valueWrapper.get());
        if (cacheName.equals(TEST_CACHE_NAME_PROTO)) {
            RemoteCache nativeCache = (RemoteCache)cache.getNativeCache();
            RemoteCache jsonCache = nativeCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build());
            Object jsonValue = jsonCache.get((Object)"key");
            AssertJUnit.assertEquals((Object)"\n{\n   \"_type\": \"org.infinispan.commons.NullValue\"\n}\n", (Object)jsonValue);
        }
    }
}

