/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.InfinispanSessionRepositoryTCK;
import org.infinispan.spring.remote.provider.SpringRemoteCacheManager;
import org.infinispan.spring.remote.session.InfinispanRemoteSessionRepository;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="spring.session.InfinispanRemoteSessionRepositoryTest", groups={"functional"})
public class InfinispanRemoteSessionRepositoryTest
extends InfinispanSessionRepositoryTCK {
    private EmbeddedCacheManager embeddedCacheManager;
    private HotRodServer hotrodServer;
    private RemoteCacheManager remoteCacheManager;
    private SpringRemoteCacheManager springRemoteCacheManager;

    @Factory
    public Object[] factory() {
        return new Object[]{new InfinispanRemoteSessionRepositoryTest().mediaType(MediaType.APPLICATION_PROTOSTREAM), new InfinispanRemoteSessionRepositoryTest().mediaType(MediaType.APPLICATION_SERIALIZED_OBJECT)};
    }

    @BeforeClass
    public void beforeClass() {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheConfiguration = HotRodTestingUtil.hotRodCacheConfiguration((MediaType)this.mediaType);
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)cacheConfiguration);
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.embeddedCacheManager, (int)19723);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        if (this.mediaType.equals((Object)MediaType.APPLICATION_SERIALIZED_OBJECT)) {
            builder.marshaller(JavaSerializationMarshaller.class);
        } else {
            builder.marshaller(ProtoStreamMarshaller.class);
        }
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.springRemoteCacheManager = new SpringRemoteCacheManager(this.remoteCacheManager);
    }

    @AfterMethod
    public void afterMethod() {
        this.remoteCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.springRemoteCacheManager.stop();
        this.hotrodServer.stop();
        this.embeddedCacheManager.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return this.springRemoteCacheManager.getCache("");
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) {
        InfinispanRemoteSessionRepository sessionRepository = new InfinispanRemoteSessionRepository(springCache);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        super.testThrowingExceptionOnNullSpringCache();
    }

    public void testCreatingSession() throws Exception {
        super.testCreatingSession();
    }

    public void testSavingSession() throws Exception {
        super.testSavingSession();
    }

    public void testDeletingSession() throws Exception {
        super.testDeletingSession();
    }

    public void testEvictingSession() throws Exception {
        super.testEvictingSession();
    }

    public void testUpdatingTTLOnAccessingData() throws Exception {
        super.testUpdatingTTLOnAccessingData();
    }
}

