/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.provider.sample;

import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SampleHotrodServerLifecycleBean
implements InitializingBean,
DisposableBean {
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotrodServer;
    private String remoteCacheName;
    private String remoteBackupCacheName;
    private String customCacheName;

    public void setRemoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
    }

    public void setRemoteBackupCacheName(String remoteBackupCacheName) {
        this.remoteBackupCacheName = remoteBackupCacheName;
    }

    public void setCustomCacheName(String customCacheName) {
        this.customCacheName = customCacheName;
    }

    public void afterPropertiesSet() throws Exception {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_SERIALIZED_OBJECT);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        Configuration configuration = builder.build();
        this.cacheManager.defineConfiguration(this.remoteCacheName, configuration);
        this.cacheManager.defineConfiguration(this.remoteBackupCacheName, configuration);
        this.cacheManager.defineConfiguration(this.customCacheName, configuration);
        HotRodServerConfigurationBuilder hcb = new HotRodServerConfigurationBuilder();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)15233, (HotRodServerConfigurationBuilder)hcb);
    }

    public void destroy() {
        this.cacheManager.stop();
        this.hotrodServer.stop();
    }
}

