/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.provider;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.remote.provider.SpringRemoteCacheManager;
import org.infinispan.test.Exceptions;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.cache.Cache;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringRemoteCacheManagerWithReadWriteTimeoutTest", groups={"functional", "smoke"})
public class SpringRemoteCacheManagerWithReadWriteTimeoutTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = "spring.remote.cache.manager.Test";
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, this.cacheManager.getDefaultCacheConfiguration());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        return this.cacheManager;
    }

    @BeforeClass
    public void setupRemoteCacheFactory() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)ServerTestingUtil.findFreePort(), (HotRodServerConfigurationBuilder)serverBuilder);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterClass
    public void destroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @Test
    public final void springRemoteCacheManagerWithTimeoutShouldThrowTimeoutExceptions() {
        SpringRemoteCacheManager objectUnderTest = new SpringRemoteCacheManager(this.remoteCacheManager, 500L, 750L);
        SpringCache defaultCache = objectUnderTest.getCache(TEST_CACHE_NAME);
        AssertJUnit.assertEquals((String)"getCache(spring.remote.cache.manager.Test) should have returned a cache name \"spring.remote.cache.manager.Test\". However, the returned cache has a different name.", (String)TEST_CACHE_NAME, (String)defaultCache.getName());
        defaultCache.put((Object)"k1", (Object)"v1");
        CountDownLatch latch = new CountDownLatch(1);
        this.cacheManager.getCache(TEST_CACHE_NAME).getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)new DelayingInterceptor(latch, 700L, 800L), 0);
        Exceptions.expectException(CacheException.class, TimeoutException.class, () -> SpringRemoteCacheManagerWithReadWriteTimeoutTest.lambda$springRemoteCacheManagerWithTimeoutShouldThrowTimeoutExceptions$0((Cache)defaultCache));
        Exceptions.expectException(CacheException.class, TimeoutException.class, () -> SpringRemoteCacheManagerWithReadWriteTimeoutTest.lambda$springRemoteCacheManagerWithTimeoutShouldThrowTimeoutExceptions$1((Cache)defaultCache));
    }

    private static /* synthetic */ void lambda$springRemoteCacheManagerWithTimeoutShouldThrowTimeoutExceptions$1(Cache defaultCache) throws Exception {
        defaultCache.put((Object)"k1", (Object)"v2");
    }

    private static /* synthetic */ void lambda$springRemoteCacheManagerWithTimeoutShouldThrowTimeoutExceptions$0(Cache defaultCache) throws Exception {
        defaultCache.get((Object)"k1");
    }

    private static class DelayingInterceptor
    extends DDAsyncInterceptor {
        private final long readDelay;
        private final long writeDelay;
        private final CountDownLatch latch;

        private DelayingInterceptor(CountDownLatch latch, long readDelay, long writeDelay) {
            this.latch = latch;
            this.readDelay = readDelay;
            this.writeDelay = writeDelay;
        }

        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
            this.latch.await(this.readDelay, TimeUnit.MILLISECONDS);
            return super.visitGetCacheEntryCommand(ctx, command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.latch.await(this.writeDelay, TimeUnit.MILLISECONDS);
            return super.visitPutKeyValueCommand(ctx, command);
        }
    }
}

