/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.InfinispanSessionRepositoryTCK;
import org.infinispan.spring.remote.session.InfinispanRemoteSessionRepository;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.session.InfinispanRemoteSessionRepositoryTest", groups={"functional"})
public class InfinispanRemoteSessionRepositoryTest
extends InfinispanSessionRepositoryTCK {
    private EmbeddedCacheManager embeddedCacheManager;
    private HotRodServer hotrodServer;
    private RemoteCacheManager remoteCacheManager;
    private ThreadPoolTaskExecutor executor;

    @BeforeClass
    public void beforeClass() {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheConfiguration = new org.infinispan.configuration.cache.ConfigurationBuilder();
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)cacheConfiguration);
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.embeddedCacheManager, (int)19723);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setCorePoolSize(4);
        this.executor.setMaxPoolSize(4);
        this.executor.setThreadNamePrefix("default_task_executor_thread");
        this.executor.initialize();
    }

    @AfterMethod
    public void afterMethod() {
        this.remoteCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
        this.embeddedCacheManager.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.remoteCacheManager.getCache());
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) {
        InfinispanRemoteSessionRepository sessionRepository = new InfinispanRemoteSessionRepository(springCache, (TaskExecutor)this.executor);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        super.testThrowingExceptionOnNullSpringCache();
    }

    public void testCreatingSession() throws Exception {
        super.testCreatingSession();
    }

    public void testSavingSession() throws Exception {
        super.testSavingSession();
    }

    public void testDeletingSession() throws Exception {
        super.testDeletingSession();
    }

    public void testEvictingSession() throws Exception {
        super.testEvictingSession();
    }

    public void testUpdatingTTLOnAccessingData() throws Exception {
        super.testUpdatingTTLOnAccessingData();
    }
}

