/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.spring.common.session.InfinispanApplicationPublishedBridgeTCK;
import org.infinispan.spring.remote.session.InfinispanRemoteSessionRepository;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.session.RemoteApplicationPublishedBridgeTest", groups={"unit"})
public class RemoteApplicationPublishedBridgeTest
extends InfinispanApplicationPublishedBridgeTCK {
    private EmbeddedCacheManager embeddedCacheManager;
    private HotRodServer hotrodServer;
    private RemoteCacheManager remoteCacheManager;
    private ThreadPoolTaskExecutor executor;

    @BeforeClass
    public void beforeClass() {
        this.embeddedCacheManager = TestCacheManagerFactory.createCacheManager();
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.embeddedCacheManager, (int)19723);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setCorePoolSize(4);
        this.executor.setMaxPoolSize(4);
        this.executor.setThreadNamePrefix("infinispan_remote_task_executor_thread");
        this.executor.initialize();
    }

    @AfterMethod
    public void afterMethod() {
        this.remoteCacheManager.getCache().clear();
    }

    @AfterClass
    public void afterClass() {
        this.embeddedCacheManager.stop();
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        super.init();
    }

    protected SpringCache createSpringCache() {
        return new SpringCache((BasicCache)this.remoteCacheManager.getCache());
    }

    protected void callEviction() {
        this.embeddedCacheManager.getCache().getAdvancedCache().getExpirationManager().processExpiration();
    }

    protected AbstractInfinispanSessionRepository createRepository(SpringCache springCache) {
        InfinispanRemoteSessionRepository sessionRepository = new InfinispanRemoteSessionRepository(springCache, (TaskExecutor)this.executor);
        sessionRepository.afterPropertiesSet();
        return sessionRepository;
    }

    public void testEventBridge() throws Exception {
        super.testEventBridge();
    }

    public void testUnregistration() throws Exception {
        super.testUnregistration();
    }
}

