/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote.session;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.task.TaskExecutor;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;

@ClientListener
public class RemoteApplicationPublishedBridge
extends AbstractApplicationPublisherBridge {
    private final TaskExecutor taskExecutor;

    public RemoteApplicationPublishedBridge(SpringCache eventSource, TaskExecutor taskExecutor) {
        super(eventSource);
        this.taskExecutor = taskExecutor;
    }

    @Override
    protected void registerListener() {
        ((RemoteCache)this.eventSource.getNativeCache()).addClientListener((Object)this);
    }

    @Override
    public void unregisterListener() {
        ((RemoteCache)this.eventSource.getNativeCache()).removeClientListener((Object)this);
    }

    @ClientCacheEntryCreated
    public void processCacheEntryCreated(ClientCacheEntryCreatedEvent event) {
        this.taskExecutor.execute(() -> {
            Session session = (Session)this.eventSource.get(event.getKey()).get();
            if (session != null) {
                this.emitSessionCreatedEvent(session);
            }
        });
    }

    @ClientCacheEntryExpired
    public void processCacheEntryExpired(ClientCacheEntryExpiredEvent event) {
        this.springEventsPublisher.ifPresent(p -> p.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this.eventSource, (Session)new MapSession((String)event.getKey()))));
    }

    @ClientCacheEntryRemoved
    public void processCacheEntryDestroyed(ClientCacheEntryRemovedEvent event) {
        this.springEventsPublisher.ifPresent(p -> p.publishEvent((ApplicationEvent)new SessionDestroyedEvent((Object)this.eventSource, (Session)new MapSession((String)event.getKey()))));
    }
}

