/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.tasks.DummyTask;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.concurrent.BlockingManager;

public class DummyTaskEngine
implements TaskEngine {
    private final Set<String> tasks = new HashSet<String>();
    private CompletableFuture<String> slow;

    public DummyTaskEngine() {
        for (DummyTaskTypes type : DummyTaskTypes.values()) {
            this.tasks.add(type.toString());
        }
        this.slow = new CompletableFuture();
    }

    public String getName() {
        return "Dummy";
    }

    public List<Task> getTasks() {
        ArrayList<Task> taskDetails = new ArrayList<Task>();
        this.tasks.forEach(task -> taskDetails.add(new DummyTask((String)task)));
        return taskDetails;
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context, BlockingManager blockingManager) {
        switch (DummyTaskTypes.valueOf(taskName)) {
            case SUCCESSFUL_TASK: {
                return CompletableFuture.completedFuture("result");
            }
            case PARAMETERIZED_TASK: {
                Map params = (Map)context.getParameters().get();
                return CompletableFuture.completedFuture(params.get("parameter"));
            }
            case FAILING_TASK: {
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(new Exception("exception"));
                return f;
            }
            case SLOW_TASK: {
                return this.slow;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setSlowTask(CompletableFuture<String> slow) {
        this.slow = slow;
    }

    public CompletableFuture<String> getSlowTask() {
        return this.slow;
    }

    public boolean handles(String taskName) {
        return this.tasks.contains(taskName);
    }

    static enum DummyTaskTypes {
        SUCCESSFUL_TASK,
        PARAMETERIZED_TASK,
        FAILING_TASK,
        SLOW_TASK;

    }
}

