/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.tasks.DummyTask;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.spi.TaskEngine;

public class DummyTaskEngine
implements TaskEngine {
    final Set<String> tasks = new HashSet<String>();
    final CompletableFuture<String> slow;

    public DummyTaskEngine() {
        for (DummyTaskTypes type : DummyTaskTypes.values()) {
            this.tasks.add(type.toString());
        }
        this.slow = new CompletableFuture();
    }

    public String getName() {
        return "Dummy";
    }

    public List<Task> getTasks() {
        ArrayList<Task> taskDetails = new ArrayList<Task>();
        this.tasks.forEach(task -> taskDetails.add(new DummyTask((String)task)));
        return taskDetails;
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context) {
        switch (DummyTaskTypes.valueOf(taskName)) {
            case SUCCESSFUL_TASK: {
                return CompletableFuture.completedFuture("result");
            }
            case FAILING_TASK: {
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(new Exception("exception"));
                return f;
            }
            case SLOW_TASK: {
                return this.slow;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean handles(String taskName) {
        return this.tasks.contains(taskName);
    }

    static enum DummyTaskTypes {
        SUCCESSFUL_TASK,
        FAILING_TASK,
        SLOW_TASK;

    }
}

