/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.tasks.DummyTaskEngine;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecution;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.impl.TaskManagerImpl;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="tasks.TaskManagerTest", groups={"functional"})
public class TaskManagerTest
extends SingleCacheManagerTest {
    protected TaskManagerImpl taskManager;
    private DummyTaskEngine taskEngine;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.taskManager = (TaskManagerImpl)this.cacheManager.getGlobalComponentRegistry().getComponent(TaskManager.class);
        this.taskEngine = new DummyTaskEngine();
        this.taskManager.registerTaskEngine((TaskEngine)this.taskEngine);
    }

    public void testRunTask() throws InterruptedException, ExecutionException {
        CompletableFuture okTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.SUCCESSFUL_TASK.name(), new TaskContext());
        AssertJUnit.assertEquals((String)"result", (String)((String)okTask.get()));
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        CompletableFuture koTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.FAILING_TASK.name(), new TaskContext());
        String message = (String)((CompletableFuture)koTask.handle((r, e) -> e.getCause().getMessage())).get();
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        AssertJUnit.assertEquals((String)"exception", (String)message);
        CompletableFuture slowTask = this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), new TaskContext());
        Collection currentTasks = this.taskManager.getCurrentTasks();
        AssertJUnit.assertEquals((int)1, (int)currentTasks.size());
        TaskExecution execution = (TaskExecution)currentTasks.iterator().next();
        AssertJUnit.assertEquals((String)DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), (String)execution.getName());
        this.taskEngine.slow.complete("slow");
        AssertJUnit.assertEquals((int)0, (int)this.taskManager.getCurrentTasks().size());
        AssertJUnit.assertEquals((Object)"slow", slowTask.get());
    }
}

