/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.lock.LockManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeStructureSupport;

public abstract class NodeLockSupport {
    static final Fqn A = Fqn.fromString((String)"/a");
    static final Fqn B = Fqn.fromString((String)"/b");
    static final Fqn C = Fqn.fromString((String)"/c");
    static final Fqn D = Fqn.fromString((String)"/d");
    static final Fqn E = Fqn.fromString((String)"/e");
    static final Object k = "key";
    static final Object vA = "valueA";
    static final Object vB = "valueB";
    static final Object vC = "valueC";
    static final Object vD = "valueD";
    static final Object vE = "valueE";
    static final Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
    static final Fqn A_B_C = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)C);
    static final Fqn A_B_C_E = Fqn.fromRelativeFqn((Fqn)A_B_C, (Fqn)E);
    static final Fqn A_B_D = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)D);
    static final Fqn C_E = Fqn.fromRelativeFqn((Fqn)C, (Fqn)E);
    static final Fqn D_B = Fqn.fromRelativeFqn((Fqn)D, (Fqn)B);
    static final Fqn D_B_C = Fqn.fromRelativeFqn((Fqn)D_B, (Fqn)C);
    protected ThreadLocal<Cache<Object, Object>> cacheTL = new ThreadLocal();
    protected ThreadLocal<TransactionManager> tmTL = new ThreadLocal();
    protected ThreadLocal<TreeCache> treeCacheTL = new ThreadLocal();

    protected void checkLocks() {
        Cache<Object, Object> cache = this.cacheTL.get();
        LockManager lm = TestingUtil.extractLockManager(cache);
        assert (!TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A));
        assert (!TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)Fqn.ROOT));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)C));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A_B));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A_B_C));
    }

    protected void checkLocksDeep() {
        Cache<Object, Object> cache = this.cacheTL.get();
        LockManager lm = TestingUtil.extractLockManager(cache);
        assert (!TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A));
        assert (!TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)Fqn.ROOT));
        assert (!TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A_B_D));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)C));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)C_E));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A_B));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A_B_C));
        assert (TreeStructureSupport.isLocked(cache, (LockManager)lm, (Fqn)A_B_C_E));
    }

    protected void assertNoLocks() {
        Cache<Object, Object> cache = this.cacheTL.get();
        LockManager lm = TestingUtil.extractLockManager(cache);
        for (Object key : cache.keySet()) {
            assert (!lm.isLocked(key));
        }
    }
}

