/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.DummyTransactionManagerLookup;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.SyncReplTxTest")
public class SyncReplTxTest
extends MultipleCacheManagersTest {
    TreeCache<Object, Object> cache1;
    TreeCache<Object, Object> cache2;

    protected void createCacheManagers() throws Throwable {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setFetchInMemoryState(false);
        c.setInvocationBatchingEnabled(true);
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.createClusteredCaches(2, "replSync", c);
        Cache c1 = this.cache(0, "replSync");
        Cache c2 = this.cache(1, "replSync");
        this.cache1 = new TreeCacheImpl(c1);
        this.cache2 = new TreeCacheImpl(c2);
    }

    private TransactionManager beginTransaction(Cache cache) throws NotSupportedException, SystemException {
        TransactionManager mgr = TestingUtil.getTransactionManager((Cache)cache);
        mgr.begin();
        return mgr;
    }

    public void testBasicOperation() throws SystemException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Fqn f = Fqn.fromString((String)"/test/data");
        String k = "key";
        String v = "value";
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getRoot().getChild(f));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getRoot().getChild(f));
        Node node = this.cache1.getRoot().addChild(f);
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)node);
        TransactionManager tm = this.beginTransaction(this.cache1.getCache());
        node.put((Object)k, (Object)v);
        tm.commit();
        AssertJUnit.assertEquals((Object)v, (Object)node.get((Object)k));
        AssertJUnit.assertEquals((Object)v, (Object)this.cache1.get(f, (Object)k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)v, (Object)this.cache2.get(f, (Object)k));
    }
}

