/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.NodeAPITest")
public class NodeAPITest {
    static final Fqn A = Fqn.fromString((String)"/a");
    static final Fqn B = Fqn.fromString((String)"/b");
    static final Fqn C = Fqn.fromString((String)"/c");
    static final Fqn D = Fqn.fromString((String)"/d");
    Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
    Fqn A_C = Fqn.fromRelativeFqn((Fqn)A, (Fqn)C);
    TransactionManager tm;
    TreeCache cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c.setInvocationBatchingEnabled(true);
        CacheManager cm = TestCacheManagerFactory.createCacheManager((Configuration)c);
        this.cache = new TreeCacheImpl(cm.getCache());
        this.tm = TestingUtil.getTransactionManager((Cache)this.cache.getCache());
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches((Cache[])new Cache[]{this.cache.getCache()});
    }

    public void testAddingData() {
        Node rootNode = this.cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)nodeA.get((Object)"key"));
    }

    public void testAddingDataTx() throws Exception {
        Node rootNode = this.cache.getRoot();
        this.tm.begin();
        Node nodeA = rootNode.addChild(A);
        nodeA.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)nodeA.get((Object)"key"));
        this.tm.commit();
    }

    public void testOverwritingDataTx() throws Exception {
        Node rootNode = this.cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)nodeA.get((Object)"key"));
        this.tm.begin();
        rootNode.removeChild(A);
        this.cache.put(A, (Object)"k2", (Object)"v2");
        this.tm.commit();
        AssertJUnit.assertNull((Object)nodeA.get((Object)"key"));
        AssertJUnit.assertEquals((Object)"v2", (Object)nodeA.get((Object)"k2"));
    }

    public void testParentsAndChildren() {
        Node rootNode = this.cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeC = nodeA.addChild(C);
        Node nodeD = rootNode.addChild(D);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeD.getParent());
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(B));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertEquals((Object)nodeA, (Object)rootNode.getChild(A));
        AssertJUnit.assertEquals((Object)nodeD, (Object)rootNode.getChild(D));
        AssertJUnit.assertEquals((Object)nodeB, (Object)nodeA.getChild(B));
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeA.getChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().contains(nodeB));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().contains(nodeC));
        AssertJUnit.assertEquals((int)2, (int)nodeA.getChildren().size());
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeD));
        AssertJUnit.assertEquals((int)2, (int)rootNode.getChildren().size());
        AssertJUnit.assertEquals((boolean)true, (boolean)rootNode.removeChild(A));
        AssertJUnit.assertFalse((boolean)rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeD));
        AssertJUnit.assertEquals((int)1, (int)rootNode.getChildren().size());
        AssertJUnit.assertEquals((String)"double remove", (boolean)false, (boolean)rootNode.removeChild(A));
        AssertJUnit.assertEquals((String)"double remove", (boolean)false, (boolean)rootNode.removeChild(A.getLastElement()));
    }

    public void testImmutabilityOfData() {
        Node rootNode = this.cache.getRoot();
        rootNode.put((Object)"key", (Object)"value");
        Map m = rootNode.getData();
        try {
            m.put("x", "y");
            AssertJUnit.fail((String)"Map should be immutable!!");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            rootNode.getKeys().add(new Object());
            AssertJUnit.fail((String)"Key set should be immutable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDefensiveCopyOfData() {
        Node rootNode = this.cache.getRoot();
        rootNode.put((Object)"key", (Object)"value");
        Map data = rootNode.getData();
        Set keys = rootNode.getKeys();
        assert (keys.size() == 1);
        assert (keys.contains("key"));
        assert (data.size() == 1);
        assert (data.containsKey("key"));
        rootNode.put((Object)"key2", (Object)"value2");
        assert (keys.size() == 1);
        assert (keys.contains("key"));
        assert (data.size() == 1);
        assert (data.containsKey("key"));
    }

    public void testDefensiveCopyOfChildren() {
        Node rootNode = this.cache.getRoot();
        Fqn childFqn = Fqn.fromString((String)"/child");
        rootNode.addChild(childFqn).put((Object)"k", (Object)"v");
        Set children = rootNode.getChildren();
        Set childrenNames = rootNode.getChildrenNames();
        assert (childrenNames.size() == 1);
        assert (childrenNames.contains(childFqn.getLastElement()));
        assert (children.size() == 1);
        assert (((Node)children.iterator().next()).getFqn().equals((Object)childFqn));
        rootNode.addChild(Fqn.fromString((String)"/child2"));
        assert (childrenNames.size() == 1);
        assert (childrenNames.contains(childFqn.getLastElement()));
        assert (children.size() == 1);
        assert (((Node)children.iterator().next()).getFqn().equals((Object)childFqn));
    }

    public void testImmutabilityOfChildren() {
        Node rootNode = this.cache.getRoot();
        rootNode.addChild(A);
        try {
            rootNode.getChildren().clear();
            AssertJUnit.fail((String)"Collection of child nodes returned in getChildren() should be immutable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetChildAPI() {
        Node rootNode = this.cache.getRoot();
        Node childA = rootNode.addChild(A);
        childA.addChild(B).addChild(C);
        rootNode.getChild(A).put((Object)"key", (Object)"value");
        rootNode.getChild(A).getChild(B).put((Object)"key", (Object)"value");
        rootNode.getChild(A).getChild(B).getChild(C).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)rootNode.getChild(A).get((Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)rootNode.getChild(A).getChild(B).get((Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)rootNode.getChild(A).getChild(B).getChild(C).get((Object)"key"));
        AssertJUnit.assertNull((Object)rootNode.getChild(Fqn.fromElements((Object[])new Object[]{"nonexistent"})));
    }

    public void testClearingData() {
        Node rootNode = this.cache.getRoot();
        rootNode.put((Object)"k", (Object)"v");
        rootNode.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)rootNode.getKeys().size());
        rootNode.clearData();
        AssertJUnit.assertEquals((int)0, (int)rootNode.getKeys().size());
        AssertJUnit.assertTrue((boolean)rootNode.getData().isEmpty());
    }

    public void testClearingDataTx() throws Exception {
        Node rootNode = this.cache.getRoot();
        this.tm.begin();
        rootNode.put((Object)"k", (Object)"v");
        rootNode.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)rootNode.getKeys().size());
        rootNode.clearData();
        AssertJUnit.assertEquals((int)0, (int)rootNode.getKeys().size());
        AssertJUnit.assertTrue((boolean)rootNode.getData().isEmpty());
        this.tm.commit();
        AssertJUnit.assertTrue((boolean)rootNode.getData().isEmpty());
    }

    public void testPutData() {
        Node rootNode = this.cache.getRoot();
        AssertJUnit.assertTrue((boolean)rootNode.getData().isEmpty());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        map.put("k2", "v2");
        rootNode.putAll(map);
        AssertJUnit.assertEquals((int)2, (int)rootNode.getData().size());
        AssertJUnit.assertEquals((Object)"v1", (Object)rootNode.get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)rootNode.get((Object)"k2"));
        map.clear();
        map.put("k3", "v3");
        rootNode.putAll(map);
        AssertJUnit.assertEquals((int)3, (int)rootNode.getData().size());
        AssertJUnit.assertEquals((Object)"v1", (Object)rootNode.get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)rootNode.get((Object)"k2"));
        AssertJUnit.assertEquals((Object)"v3", (Object)rootNode.get((Object)"k3"));
        map.clear();
        map.put("k4", "v4");
        map.put("k5", "v5");
        rootNode.replaceAll(map);
        AssertJUnit.assertEquals((int)2, (int)rootNode.getData().size());
        AssertJUnit.assertEquals((Object)"v4", (Object)rootNode.get((Object)"k4"));
        AssertJUnit.assertEquals((Object)"v5", (Object)rootNode.get((Object)"k5"));
    }

    public void testGetChildrenNames() throws Exception {
        Node rootNode = this.cache.getRoot();
        rootNode.addChild(A).put((Object)"k", (Object)"v");
        rootNode.addChild(B).put((Object)"k", (Object)"v");
        HashSet<Object> childrenNames = new HashSet<Object>();
        childrenNames.add(A.getLastElement());
        childrenNames.add(B.getLastElement());
        AssertJUnit.assertEquals(childrenNames, (Object)rootNode.getChildrenNames());
        this.tm.begin();
        rootNode.removeChild(B);
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(B));
        childrenNames.remove(B.getLastElement());
        AssertJUnit.assertEquals(childrenNames, (Object)rootNode.getChildrenNames());
        this.tm.commit();
        AssertJUnit.assertEquals(childrenNames, (Object)rootNode.getChildrenNames());
    }

    public void testDoubleRemovalOfData() throws Exception {
        assert (this.tm.getTransaction() == null);
        this.cache.put("/foo/1/2/3", (Object)"item", (Object)1);
        assert (this.tm.getTransaction() == null);
        assert (1 == (Integer)this.cache.get("/foo/1/2/3", (Object)"item"));
        this.tm.begin();
        assert (1 == (Integer)this.cache.get("/foo/1/2/3", (Object)"item"));
        this.cache.removeNode("/foo/1");
        AssertJUnit.assertNull((Object)this.cache.getNode("/foo/1"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.cache.removeNode("/foo/1/2/3");
        System.out.println("Cache: " + this.cache);
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1/2/3", (Object)"item"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.tm.commit();
        AssertJUnit.assertFalse((boolean)this.cache.exists("/foo/1"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1/2/3", (Object)"item"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
    }

    public void testDoubleRemovalOfData2() throws Exception {
        this.cache.put("/foo/1/2", (Object)"item", (Object)1);
        this.tm.begin();
        AssertJUnit.assertEquals((Object)this.cache.get("/foo/1", (Object)"item"), null);
        this.cache.removeNode("/foo/1");
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.cache.removeNode("/foo/1/2");
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.tm.commit();
        AssertJUnit.assertFalse((boolean)this.cache.exists("/foo/1"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1/2", (Object)"item"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
    }
}

