/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.profiling.testinternals.FqnGenerator;
import org.infinispan.profiling.testinternals.Generator;
import org.infinispan.profiling.testinternals.TaskRunner;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.TreeTestingUtil;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheImpl;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="profiling.TreeProfileTest", enabled=false)
public class TreeProfileTest {
    Log log = LogFactory.getLog(TreeProfileTest.class);
    protected static final long NUM_OPERATIONS = 1000000L;
    protected static final int NUM_THREADS = 25;
    protected static final int MAX_RANDOM_SLEEP_MILLIS = 1;
    protected static final int MAX_DEPTH = 3;
    protected static final int MAX_OVERALL_NODES = 2000;
    protected static final int WARMUP_LOOPS = 20000;
    protected static final boolean USE_SLEEP = false;
    private CacheManager cacheManager;
    protected TreeCache cache;
    private List<Fqn> fqns = new ArrayList<Fqn>(2000);

    @BeforeMethod
    public void setUp() {
        Configuration cfg = new Configuration();
        cfg.setInvocationBatchingEnabled(true);
        cfg.setCacheMode(Configuration.CacheMode.LOCAL);
        cfg.setConcurrencyLevel(2000);
        cfg.setLockAcquisitionTimeout(120000L);
        cfg.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        this.cacheManager = new DefaultCacheManager(cfg);
        Cache c = this.cacheManager.getCache();
        this.cache = new TreeCacheImpl(c);
    }

    @AfterMethod
    public void tearDown() {
        TreeTestingUtil.killTreeCaches(this.cache);
        TestingUtil.killCacheManagers((CacheManager[])new CacheManager[]{this.cacheManager});
    }

    public void testLocalMode() throws Exception {
        this.runCompleteTest();
    }

    private void runCompleteTest() throws Exception {
        this.init();
        this.startup();
        this.warmup();
        this.doTest();
        System.in.read();
    }

    protected void init() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting init() phase");
        this.fqns.clear();
        for (int i = 0; i < 2000; ++i) {
            Fqn fqn;
            while (this.fqns.contains(fqn = FqnGenerator.createRandomFqn(3))) {
            }
            if (i % 100 == 0) {
                this.log.warn((Object)("Generated " + i + " fqns"));
            }
            this.fqns.add(fqn);
        }
        System.gc();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished init() phase.  " + this.printDuration(duration)));
    }

    protected void startup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting cache");
        this.cache.start();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    private void warmup() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        TaskRunner runner = new TaskRunner(25);
        this.log.warn((Object)"Starting warmup");
        for (final Fqn fqn : this.fqns) {
            runner.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TreeProfileTest.this.cache.put(fqn, (Object)"key", Collections.emptyMap());
                    }
                    catch (Exception e) {
                        TreeProfileTest.this.log.warn((Object)"Caught Exception", (Throwable)e);
                    }
                }
            });
        }
        for (int i = 0; i < 20000; ++i) {
            runner.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Fqn fqn = (Fqn)Generator.getRandomElement((List)TreeProfileTest.this.fqns);
                        DummyTransactionManager.getInstance().begin();
                        TreeProfileTest.this.cache.get(fqn, (Object)"key");
                        DummyTransactionManager.getInstance().commit();
                        DummyTransactionManager.getInstance().begin();
                        TreeProfileTest.this.cache.put(fqn, (Object)"key", (Object)"Value");
                        DummyTransactionManager.getInstance().commit();
                        DummyTransactionManager.getInstance().begin();
                        TreeProfileTest.this.cache.remove(fqn, (Object)"key");
                        DummyTransactionManager.getInstance().commit();
                    }
                    catch (Exception e) {
                        TreeProfileTest.this.log.warn((Object)"Caught Exception", (Throwable)e);
                    }
                }
            });
        }
        runner.stop();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished warmup.  " + this.printDuration(duration)));
        this.startup();
    }

    private void doTest() throws Exception {
        TaskRunner runner = new TaskRunner(25);
        this.log.warn((Object)"Starting test");
        long print = 100000L;
        AtomicLong durationPuts = new AtomicLong();
        AtomicLong durationGets = new AtomicLong();
        AtomicLong durationRemoves = new AtomicLong();
        long stElapsed = System.nanoTime();
        int i = 0;
        while ((long)i < 1000000L) {
            MyRunnable r = null;
            switch (i % 3) {
                case 0: {
                    r = new Putter(i, durationPuts);
                    break;
                }
                case 1: {
                    r = new Getter(i, durationGets);
                    break;
                }
                case 2: {
                    r = new Remover(i, durationRemoves);
                }
            }
            if ((long)i % print == 0L) {
                this.log.warn((Object)("processing iteration " + i));
            }
            runner.execute((Runnable)r);
            ++i;
        }
        this.log.warn((Object)"Finished generating runnables; awaiting executor completion");
        runner.stop();
        long elapsedTimeNanos = System.nanoTime() - stElapsed;
        this.log.warn((Object)("Finished test.  " + this.printDuration((long)this.toMillis(elapsedTimeNanos))));
        this.log.warn((Object)("Throughput: " + 1.0E9 / this.toMillis(elapsedTimeNanos) + " operations per second (roughly equal numbers of PUT, GET and REMOVE)"));
        this.log.warn((Object)("Average GET time: " + this.printAvg(durationGets.get())));
        this.log.warn((Object)("Average PUT time: " + this.printAvg(durationPuts.get())));
        this.log.warn((Object)("Average REMOVE time: " + this.printAvg(durationRemoves.get())));
    }

    private String printAvg(long totalNanos) {
        double nOps = 333333.0;
        double avg = (double)totalNanos / nOps;
        double avgMicros = avg / 1000.0;
        return avgMicros + " \u00b5s";
    }

    private double toMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    protected String printDuration(long duration) {
        if (duration > 2000L) {
            double dSecs = (double)duration / 1000.0;
            return "Duration: " + dSecs + " seconds";
        }
        return "Duration: " + duration + " millis";
    }

    private class Remover
    extends MyRunnable {
        private Remover(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.REMOVE;
        }
    }

    private class Getter
    extends MyRunnable {
        private Getter(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.GET;
        }
    }

    private class Putter
    extends MyRunnable {
        private Putter(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.PUT;
        }
    }

    private abstract class MyRunnable
    implements Runnable {
        int id;
        Mode mode;
        AtomicLong duration;

        private MyRunnable() {
        }

        @Override
        public void run() {
            Fqn fqn = (Fqn)Generator.getRandomElement((List)TreeProfileTest.this.fqns);
            long d = 0L;
            long st = 0L;
            try {
                switch (this.mode) {
                    case PUT: {
                        String value = Generator.getRandomString();
                        st = System.nanoTime();
                        TreeProfileTest.this.cache.put(fqn, (Object)"key", (Object)value);
                        d = System.nanoTime() - st;
                        break;
                    }
                    case GET: {
                        st = System.nanoTime();
                        TreeProfileTest.this.cache.get(fqn, (Object)"key");
                        d = System.nanoTime() - st;
                        break;
                    }
                    case REMOVE: {
                        st = System.nanoTime();
                        TreeProfileTest.this.cache.remove(fqn, (Object)"key");
                        d = System.nanoTime() - st;
                    }
                }
            }
            catch (Exception e) {
                d = 0L;
            }
            this.duration.getAndAdd(d);
        }
    }

    static enum Mode {
        PUT,
        GET,
        REMOVE;

    }
}

