/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCacheImpl;
import org.infinispan.tree.TreeStructureSupport;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.NodeMoveAPITest")
public class NodeMoveAPITest
extends SingleCacheManagerTest {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final Fqn A = Fqn.fromString((String)"/a");
    protected static final Fqn B = Fqn.fromString((String)"/b");
    protected static final Fqn C = Fqn.fromString((String)"/c");
    protected static final Fqn D = Fqn.fromString((String)"/d");
    protected static final Fqn E = Fqn.fromString((String)"/e");
    static final Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
    static final Fqn A_B_C = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)C);
    static final Fqn A_B_C_E = Fqn.fromRelativeFqn((Fqn)A_B_C, (Fqn)E);
    static final Fqn A_B_D = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)D);
    static final Fqn C_E = Fqn.fromRelativeFqn((Fqn)C, (Fqn)E);
    static final Fqn D_B = Fqn.fromRelativeFqn((Fqn)D, (Fqn)B);
    static final Fqn D_B_C = Fqn.fromRelativeFqn((Fqn)D_B, (Fqn)C);
    protected static final Object k = "key";
    protected static final Object vA = "valueA";
    protected static final Object vB = "valueB";
    protected static final Object vC = "valueC";
    protected static final Object vD = "valueD";
    protected static final Object vE = "valueE";
    TreeCacheImpl<Object, Object> treeCache;
    TransactionManager tm;
    DataContainer dc;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager();
        Configuration c = new Configuration();
        c.setFetchInMemoryState(false);
        c.setInvocationBatchingEnabled(true);
        c.setLockAcquisitionTimeout(1000L);
        cm.defineConfiguration("test", c);
        this.cache = cm.getCache("test");
        this.tm = (TransactionManager)TestingUtil.extractComponent((Cache)this.cache, TransactionManager.class);
        this.treeCache = new TreeCacheImpl(this.cache);
        this.dc = (DataContainer)TestingUtil.extractComponent((Cache)this.cache, DataContainer.class);
        return cm;
    }

    public void testBasicMove() {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertEquals((String)("" + nodeA), (Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        this.log.info((Object)("BEFORE MOVE " + this.treeCache));
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        nodeC = this.treeCache.getNode(Fqn.fromRelativeFqn((Fqn)nodeB.getFqn(), (Fqn)C));
        this.log.info((Object)("POST MOVE " + this.treeCache));
        this.log.info((Object)("HC " + nodeC + " " + System.identityHashCode(nodeC)));
        Node x = this.treeCache.getRoot().getChild(Fqn.fromString((String)"b/c"));
        this.log.info((Object)("HC " + x + " " + System.identityHashCode(x)));
        AssertJUnit.assertEquals((String)("NODE C " + nodeC), (String)"/b/c", (String)nodeC.getFqn().toString());
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeB.hasChild(C));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((String)("B is parent of C: " + nodeB), (Object)nodeB, (Object)nodeC.getParent());
    }

    private Node<Object, Object> genericize(Node node) {
        return node;
    }

    public void testMoveWithChildren() {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        Node nodeD = nodeC.addChild(D);
        nodeD.put(k, vD);
        Node nodeE = nodeD.addChild(E);
        nodeE.put(k, vE);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
        this.log.info((Object)("move " + nodeC + " to " + nodeB));
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        nodeC = nodeB.getChild(C);
        nodeD = nodeC.getChild(D);
        nodeE = nodeD.getChild(E);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeB.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeB, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
    }

    public void testTxCommit() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
        this.tm.begin();
        this.treeCache.move(nodeB.getFqn(), Fqn.ROOT);
        this.tm.commit();
        nodeB = rootNode.getChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeB));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().isEmpty());
    }

    public void testTxRollback() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
        this.tm.begin();
        System.out.println("Before: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        this.treeCache.move(nodeB.getFqn(), Fqn.ROOT);
        System.out.println("After: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        this.tm.rollback();
        System.out.println("Rolled back: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        nodeA = rootNode.getChild(A);
        nodeB = nodeA.getChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
    }

    public void testLocksDeepMove() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeD = nodeB.addChild(D);
        Node nodeC = rootNode.addChild(C);
        Node nodeE = nodeC.addChild(E);
        this.assertNoLocks();
        this.tm.begin();
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        this.checkLocksDeep();
        this.tm.commit();
        this.assertNoLocks();
    }

    public void testLocks() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeC = rootNode.addChild(C);
        this.assertNoLocks();
        this.tm.begin();
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        this.checkLocks();
        this.tm.commit();
        this.assertNoLocks();
    }

    public void testConcurrency() throws InterruptedException {
        Node rootNode = this.treeCache.getRoot();
        int N = 3;
        int loops = 64;
        Fqn FQN_A = A;
        Fqn FQN_B = B;
        Fqn FQN_C = C;
        Fqn FQN_D = D;
        Fqn FQN_E = E;
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Fqn FQN_Y = Fqn.fromString((String)"/y");
        final Node[] NODES = new Node[]{rootNode.addChild(FQN_A), rootNode.addChild(FQN_B), rootNode.addChild(FQN_C), rootNode.addChild(FQN_D), rootNode.addChild(FQN_E)};
        final Node NODE_X = this.genericize(NODES[0]).addChild(FQN_X);
        final Node NODE_Y = this.genericize(NODES[1]).addChild(FQN_Y);
        Thread[] movers = new Thread[3];
        final CountDownLatch latch = new CountDownLatch(1);
        final Random rnd = new Random();
        for (int i = 0; i < 3; ++i) {
            movers[i] = new Thread("Mover-" + i){

                @Override
                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (int counter = 0; counter < 64; ++counter) {
                        NodeMoveAPITest.this.treeCache.move(NODE_X.getFqn(), NODES[rnd.nextInt(NODES.length)].getFqn());
                        TestingUtil.sleepRandom((int)250);
                        NodeMoveAPITest.this.treeCache.move(NODE_Y.getFqn(), NODES[rnd.nextInt(NODES.length)].getFqn());
                        TestingUtil.sleepRandom((int)250);
                    }
                }
            };
            movers[i].start();
        }
        latch.countDown();
        for (Thread t : movers) {
            t.join();
        }
        this.assertNoLocks();
        boolean found_x = false;
        boolean found_x_again = false;
        for (Node erased : NODES) {
            Node<Object, Object> n = this.genericize(erased);
            if (!found_x) {
                found_x = n.hasChild(FQN_X);
                continue;
            }
            found_x_again = found_x_again || n.hasChild(FQN_X);
        }
        boolean found_y = false;
        boolean found_y_again = false;
        for (Node erased : NODES) {
            Node<Object, Object> n = this.genericize(erased);
            if (!found_y) {
                found_y = n.hasChild(FQN_Y);
                continue;
            }
            found_y_again = found_y_again || n.hasChild(FQN_Y);
        }
        AssertJUnit.assertTrue((String)"Should have found x", (boolean)found_x);
        AssertJUnit.assertTrue((String)"Should have found y", (boolean)found_y);
        AssertJUnit.assertFalse((String)"Should have only found x once", (boolean)found_x_again);
        AssertJUnit.assertFalse((String)"Should have only found y once", (boolean)found_y_again);
    }

    public void testMoveInSamePlace() {
        Node rootNode = this.treeCache.getRoot();
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Node aNode = rootNode.addChild(A);
        Node xNode = aNode.addChild(FQN_X);
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
        System.out.println("Before: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        this.treeCache.move(xNode.getFqn(), aNode.getFqn());
        System.out.println("After: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
        this.assertNoLocks();
    }

    protected void checkLocks() {
        LockManager lm = TestingUtil.extractLockManager((Cache)this.cache);
        assert (TreeStructureSupport.isLocked((LockManager)lm, (Fqn)C));
        assert (TreeStructureSupport.isLocked((LockManager)lm, (Fqn)A_B_C));
    }

    protected void checkLocksDeep() {
        LockManager lm = TestingUtil.extractLockManager((Cache)this.cache);
        assert (TreeStructureSupport.isLocked((LockManager)lm, (Fqn)C));
        assert (TreeStructureSupport.isLocked((LockManager)lm, (Fqn)C_E));
        assert (TreeStructureSupport.isLocked((LockManager)lm, (Fqn)A_B_C));
        assert (TreeStructureSupport.isLocked((LockManager)lm, (Fqn)A_B_C_E));
    }

    protected void assertNoLocks() {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)this.cache);
        LockManager lm = (LockManager)cr.getComponent(LockManager.class);
        InvocationContextContainer icc = (InvocationContextContainer)cr.getComponent(InvocationContextContainer.class);
        LockAssert.assertNoLocks((LockManager)lm, (InvocationContextContainer)icc);
    }

    public void testNonexistentSource() {
        this.treeCache.put(A_B_C, (Object)"k", (Object)"v");
        assert ("v".equals(this.treeCache.get(A_B_C, (Object)"k")));
        assert (1 == this.treeCache.getNode(A_B).getChildren().size());
        assert (this.treeCache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (!this.treeCache.getNode(A_B).getChildrenNames().contains(D.getLastElement()));
        this.treeCache.move(D, A_B);
        assert ("v".equals(this.treeCache.get(A_B_C, (Object)"k")));
        assert (1 == this.treeCache.getNode(A_B).getChildren().size());
        assert (this.treeCache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (!this.treeCache.getNode(A_B).getChildrenNames().contains(D.getLastElement()));
    }

    public void testNonexistentTarget() {
        this.treeCache.put(A_B_C, (Object)"k", (Object)"v");
        assert ("v".equals(this.treeCache.get(A_B_C, (Object)"k")));
        assert (1 == this.treeCache.getNode(A_B).getChildren().size());
        assert (this.treeCache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (null == this.treeCache.getNode(D));
        System.out.println(TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        this.treeCache.move(A_B, D);
        System.out.println(TreeStructureSupport.printTree(this.treeCache, (boolean)true));
        assert (null == this.treeCache.getNode(A_B_C));
        assert (null == this.treeCache.getNode(A_B));
        assert (null != this.treeCache.getNode(D));
        assert (null != this.treeCache.getNode(D_B));
        assert (null != this.treeCache.getNode(D_B_C));
        assert ("v".equals(this.treeCache.get(D_B_C, (Object)"k")));
    }
}

