/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheImpl;
import org.infinispan.tree.TreeStructureSupport;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.NodeReplicatedMoveTest")
public class NodeReplicatedMoveTest
extends MultipleCacheManagersTest {
    static final Fqn A = Fqn.fromString((String)"/a");
    static final Fqn B = Fqn.fromString((String)"/b");
    static final Fqn C = Fqn.fromString((String)"/c");
    static final Fqn D = Fqn.fromString((String)"/d");
    static final Fqn E = Fqn.fromString((String)"/e");
    static final Object k = "key";
    static final Object vA = "valueA";
    static final Object vB = "valueB";
    static final Object vC = "valueC";
    static final Object vD = "valueD";
    static final Object vE = "valueE";
    TreeCache<Object, Object> cache1;
    TreeCache<Object, Object> cache2;
    TransactionManager tm1;

    protected void createCacheManagers() throws Throwable {
        Configuration c = NodeReplicatedMoveTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.REPL_SYNC, (boolean)true);
        c.setInvocationBatchingEnabled(true);
        this.createClusteredCaches(2, "replSync", c);
        Cache c1 = this.cache(0, "replSync");
        Cache c2 = this.cache(1, "replSync");
        this.tm1 = TestingUtil.getTransactionManager((Cache)c1);
        this.cache1 = new TreeCacheImpl(c1);
        this.cache2 = new TreeCacheImpl(c2);
    }

    public void testReplicatability() {
        Node rootNode = this.cache1.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        nodeA.put(k, vA);
        nodeB.put(k, vB);
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(k));
        this.cache1.move(nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.getRoot().getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache2.getRoot().getChild(B).get(k));
    }

    public void testReplTxCommit() throws Exception {
        Node rootNode = this.cache1.getRoot();
        Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        nodeA.put(k, vA);
        nodeB.put(k, vB);
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(k));
        this.tm1.begin();
        this.cache1.move(nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.get(A, k));
        AssertJUnit.assertNull((Object)this.cache1.get(A_B, k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.get(B, k));
        this.tm1.commit();
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.getRoot().getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache2.getRoot().getChild(B).get(k));
    }

    public void testReplTxRollback() throws Exception {
        System.out.println(TreeStructureSupport.printTree(this.cache1, (boolean)true));
        Node rootNode = this.cache1.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        nodeA.put(k, vA);
        nodeB.put(k, vB);
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(k));
        System.out.println(TreeStructureSupport.printTree(this.cache1, (boolean)true));
        this.tm1.begin();
        this.cache1.move(nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.get(A, k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.get(B, k));
        this.tm1.rollback();
        System.out.println(TreeStructureSupport.printTree(this.cache1, (boolean)true));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache1.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(k));
        AssertJUnit.assertEquals((Object)vA, (Object)this.cache2.getRoot().getChild(A).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(k));
    }
}

