/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheImpl;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.TreeCacheWithLoaderTest")
public class TreeCacheWithLoaderTest
extends SingleCacheManagerTest {
    TreeCache<String, String> cache;
    CacheStore store;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.setInvocationBatchingEnabled(true);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg());
        c.setCacheLoaderManagerConfig(clmc);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
        this.cache = new TreeCacheImpl(cm.getCache());
        CacheLoaderManager m = (CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cache.getCache(), CacheLoaderManager.class);
        this.store = m.getCacheStore();
        return cm;
    }

    public void testPersistence() throws CacheLoaderException {
        this.cache.put("/a/b/c", (Object)"key", (Object)"value");
        assert ("value".equals(this.cache.get("/a/b/c", (Object)"key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.fromString((String)"/a/b/c")).get("key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.STRUCTURE)));
        this.cache.stop();
        this.cache.start();
        assert ("value".equals(this.cache.get("/a/b/c", (Object)"key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.fromString((String)"/a/b/c")).get("key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.STRUCTURE)));
    }

    public void testRootNodePersistence() throws CacheLoaderException {
        this.cache.put(Fqn.ROOT, (Object)"key", (Object)"value");
        assert ("value".equals(this.cache.get(Fqn.ROOT, (Object)"key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.ROOT).get("key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.STRUCTURE)));
        this.cache.stop();
        this.cache.start();
        assert ("value".equals(this.cache.get(Fqn.ROOT, (Object)"key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.ROOT).get("key")));
        assert (this.store.containsKey((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.STRUCTURE)));
    }

    public void testDuplicatePersistence() throws CacheLoaderException {
        this.cache.put(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k")));
        this.cache.stop();
        this.cache.start();
        this.cache.put(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k")));
    }

    private Map<String, String> nodeContentsInCacheStore(CacheStore cs, Fqn fqn) throws CacheLoaderException {
        return (Map)cs.load((Object)new NodeKey(fqn, NodeKey.Type.DATA)).getValue();
    }
}

