/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.tree.Fqn;
import org.infinispan.util.Util;

public class NodeKey {
    final Fqn fqn;
    final Type contents;

    public NodeKey(Fqn fqn, Type contents) {
        this.contents = contents;
        this.fqn = fqn;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public Type getContents() {
        return this.contents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeKey key = (NodeKey)o;
        if (this.contents != key.contents) {
            return false;
        }
        return Util.safeEquals((Object)this.fqn, (Object)key.fqn);
    }

    public int hashCode() {
        int h = this.fqn != null ? this.fqn.hashCode() : 1;
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public String toString() {
        return "NodeKey{contents=" + (Object)((Object)this.contents) + ", fqn=" + this.fqn + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<NodeKey> {
        private static final byte DATA_BYTE = 1;
        private static final byte STRUCTURE_BYTE = 2;

        public void writeObject(ObjectOutput output, NodeKey key) throws IOException {
            output.writeObject(key.fqn);
            int type = 0;
            switch (key.contents) {
                case DATA: {
                    type = 1;
                    break;
                }
                case STRUCTURE: {
                    type = 2;
                }
            }
            output.write(type);
        }

        public NodeKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Fqn fqn = (Fqn)input.readObject();
            int typeb = input.readUnsignedByte();
            Type type = null;
            switch (typeb) {
                case 1: {
                    type = Type.DATA;
                    break;
                }
                case 2: {
                    type = Type.STRUCTURE;
                }
            }
            return new NodeKey(fqn, type);
        }

        public Set<Class<? extends NodeKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{NodeKey.class});
        }
    }

    public static enum Type {
        DATA,
        STRUCTURE;

    }
}

