/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.context.Flag;
import org.infinispan.context.FlagContainer;
import org.infinispan.tree.TreeContext;

public class TreeContextContainer
implements FlagContainer {
    private final ThreadLocal<TreeContext> tcTL = new ThreadLocal();

    public TreeContext createTreeContext() {
        TreeContext existing = this.tcTL.get();
        if (existing == null) {
            TreeContext treeContext = new TreeContext();
            this.tcTL.set(treeContext);
            return treeContext;
        }
        return existing;
    }

    public TreeContext getTreeContext() {
        return this.tcTL.get();
    }

    public TreeContext suspend() {
        TreeContext treeContext = this.tcTL.get();
        this.tcTL.remove();
        return treeContext;
    }

    public boolean hasFlag(Flag o) {
        TreeContext tc = this.tcTL.get();
        return tc != null && tc.hasFlag(o);
    }

    public Set<Flag> getFlags() {
        TreeContext treeContext = this.tcTL.get();
        return treeContext == null ? EnumSet.noneOf(Flag.class) : treeContext.getFlags();
    }

    public void setFlags(Flag ... flags) {
        this.createTreeContext().setFlags(flags);
    }

    public void setFlags(Collection<Flag> flags) {
        this.createTreeContext().setFlags(flags);
    }

    public void reset() {
        TreeContext treeContext = this.tcTL.get();
        if (treeContext != null) {
            treeContext.reset();
        }
    }

    public void remove(Flag flag) {
        TreeContext treeContext = this.tcTL.get();
        if (treeContext != null) {
            treeContext.remove(flag);
        }
    }
}

