/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.FlagTest")
public class FlagTest
extends MultipleCacheManagersTest {
    private Cache cache1;
    private Cache cache2;
    private TreeCache treeCache1;
    private TreeCache treeCache2;
    private static final String KEY = "key";
    private static final Log log = LogFactory.getLog(FlagTest.class);

    protected void createCacheManagers() throws Throwable {
        Configuration c = FlagTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.INVALIDATION_SYNC, (boolean)true);
        c.setInvocationBatchingEnabled(true);
        this.createClusteredCaches(2, "invalidatedFlagCache", c);
        this.cache1 = this.cache(0, "invalidatedFlagCache");
        this.cache2 = this.cache(1, "invalidatedFlagCache");
        TreeCacheFactory tcf = new TreeCacheFactory();
        this.treeCache1 = tcf.createTreeCache(this.cache1);
        this.treeCache2 = tcf.createTreeCache(this.cache2);
    }

    public void testTreeCacheLocalPut() throws Exception {
        Fqn fqn = Fqn.fromElements((Object[])new Object[]{"TEST"});
        this.treeCache1.put(fqn, (Object)KEY, (Object)"1", new Flag[]{Flag.CACHE_MODE_LOCAL});
        log.fatal((Object)"------- Phase 1 --------");
        this.treeCache2.put(fqn, (Object)KEY, (Object)"2", new Flag[]{Flag.CACHE_MODE_LOCAL});
        log.fatal((Object)"------- Phase 2 --------");
        assert ("2".equals(this.treeCache2.get(fqn, (Object)KEY))) : "treeCache2 was updated locally";
        log.fatal((Object)"------- Phase 3 --------");
        assert ("1".equals(this.treeCache1.get(fqn, (Object)KEY))) : "treeCache1 should not be invalidated in case of LOCAL put in treeCache2";
        log.fatal((Object)"------- Phase 4 --------");
        String fqnString = "fqnAsString";
        this.treeCache1.put(fqnString, (Object)KEY, (Object)"3", new Flag[]{Flag.CACHE_MODE_LOCAL});
        this.treeCache2.put(fqnString, (Object)KEY, (Object)"4", new Flag[]{Flag.CACHE_MODE_LOCAL});
        assert ("4".equals(this.treeCache2.get(fqnString, (Object)KEY))) : "treeCache2 was updated locally";
        assert ("3".equals(this.treeCache1.get(fqnString, (Object)KEY))) : "treeCache1 should not be invalidated in case of LOCAL put in treeCache2";
    }
}

