/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.DecoratedCache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.Flag;
import org.infinispan.tree.DecoratedCacheAdapter;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeImpl;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.NodeNotExistsException;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeStructureSupport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TreeCacheImpl<K, V>
extends TreeStructureSupport
implements TreeCache<K, V> {
    private static final Log log = LogFactory.getLog(TreeCacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final EnumSet<Flag> flagsOnCache;

    public TreeCacheImpl(Cache<?, ?> cache) {
        this(cache.getAdvancedCache());
    }

    public TreeCacheImpl(AdvancedCache<?, ?> cache) {
        super(cache, cache.getBatchContainer());
        if (cache.getConfiguration().isIndexingEnabled()) {
            throw new ConfigurationException("TreeCache cannot be used with a Cache instance configured to use indexing!");
        }
        TreeCacheImpl.assertBatchingSupported((Configuration)cache.getConfiguration());
        this.flagsOnCache = cache instanceof DecoratedCacheAdapter ? ((DecoratedCacheAdapter)cache).getFlags() : (cache instanceof DecoratedCache ? ((DecoratedCache)cache).getFlags() : null);
        this.createRoot();
    }

    private void setFlagsOnContext(Flag ... flags) {
        if (flags != null && flags.length > 0) {
            if (this.flagsOnCache == null) {
                this.tcc.setFlags(flags);
            } else {
                Object tmp = this.flagsOnCache.clone();
                ((AbstractCollection)tmp).addAll(Arrays.asList(flags));
                this.tcc.setFlags((Collection<Flag>)tmp);
            }
        } else if (this.flagsOnCache != null) {
            this.tcc.setFlags(this.flagsOnCache);
        }
    }

    @Override
    public Node<K, V> getRoot() {
        return this.getRoot(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getRoot(Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            NodeImpl nodeImpl = new NodeImpl(Fqn.ROOT, this.cache, this.batchContainer);
            return nodeImpl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V put(String fqn, K key, V value) {
        return this.put(Fqn.fromString(fqn), key, value, null);
    }

    @Override
    public V put(String fqn, K key, V value, Flag ... flags) {
        return this.put(Fqn.fromString(fqn), key, value, flags);
    }

    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data) {
        this.put(fqn, (K)data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            this.startAtomic();
            try {
                Node<? extends K, ? extends V> n = this.getNode(fqn);
                if (n == null) {
                    this.createNodeInCache(fqn);
                }
                n = this.getNode(fqn);
                n.putAll(data);
            }
            finally {
                this.endAtomic();
            }
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data) {
        this.put(Fqn.fromString(fqn), (K)data, null);
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.put(Fqn.fromString(fqn), (K)data, (V)flags);
    }

    @Override
    public V remove(Fqn fqn, K key) {
        return this.remove(fqn, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Fqn fqn, K key, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            Object object;
            this.startAtomic();
            try {
                AtomicMap map = this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.DATA));
                object = map == null ? null : map.remove(key);
            }
            catch (Throwable throwable) {
                this.endAtomic();
                throw throwable;
            }
            this.endAtomic();
            return (V)object;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V remove(String fqn, K key) {
        return this.remove(Fqn.fromString(fqn), key, null);
    }

    @Override
    public V remove(String fqn, K key, Flag ... flags) {
        return this.remove(Fqn.fromString(fqn), key, flags);
    }

    @Override
    public boolean removeNode(Fqn fqn) {
        return this.removeNode(fqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(Fqn fqn, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            boolean result;
            if (fqn.isRoot()) {
                boolean bl = false;
                return bl;
            }
            this.startAtomic();
            try {
                Node<K, V> n;
                if (trace) {
                    log.tracef("About to remove node %s", (Object)fqn);
                }
                result = (n = this.getNode(fqn.getParent())) != null && n.removeChild(fqn.getLastElement());
            }
            finally {
                this.endAtomic();
            }
            if (trace) {
                log.trace((Object)"Node successfully removed");
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public boolean removeNode(String fqn) {
        return this.removeNode(Fqn.fromString(fqn), null);
    }

    @Override
    public boolean removeNode(String fqn, Flag ... flags) {
        return this.removeNode(Fqn.fromString(fqn), flags);
    }

    @Override
    public Node<K, V> getNode(Fqn fqn) {
        return this.getNode(fqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getNode(Fqn fqn, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            block8: {
                NodeImpl nodeImpl;
                this.startAtomic();
                try {
                    if (!this.exists(fqn)) break block8;
                    nodeImpl = new NodeImpl(fqn, this.cache, this.batchContainer);
                }
                catch (Throwable throwable) {
                    this.endAtomic();
                    throw throwable;
                }
                this.endAtomic();
                return nodeImpl;
            }
            Node<K, V> node = null;
            this.endAtomic();
            return node;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public Node<K, V> getNode(String fqn) {
        return this.getNode(Fqn.fromString(fqn), null);
    }

    @Override
    public Node<K, V> getNode(String fqn, Flag ... flags) {
        return this.getNode(Fqn.fromString(fqn), flags);
    }

    @Override
    public V get(Fqn fqn, K key) {
        return this.get(fqn, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Fqn fqn, K key, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            AtomicMap m = this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.DATA));
            if (m == null) {
                V v = null;
                return v;
            }
            Object v = m.get(key);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public boolean exists(String f) {
        return this.exists(Fqn.fromString(f), null);
    }

    @Override
    public boolean exists(String fqn, Flag ... flags) {
        return this.exists(Fqn.fromString(fqn), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn fqn, Flag ... flags) {
        this.tcc.setFlags(flags);
        try {
            boolean bl = this.exists(fqn);
            return bl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V get(String fqn, K key) {
        return this.get(Fqn.fromString(fqn), key, null);
    }

    @Override
    public V get(String fqn, K key, Flag ... flags) {
        return this.get(Fqn.fromString(fqn), key, flags);
    }

    @Override
    public void move(Fqn nodeToMoveFqn, Fqn newParentFqn) throws NodeNotExistsException {
        this.move(nodeToMoveFqn, newParentFqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Fqn nodeToMoveFqn, Fqn newParentFqn, Flag ... flags) throws NodeNotExistsException {
        this.setFlagsOnContext(flags);
        try {
            if (trace) {
                log.tracef("Moving node '%s' to '%s'", (Object)nodeToMoveFqn, (Object)newParentFqn);
            }
            if (nodeToMoveFqn == null || newParentFqn == null) {
                throw new NullPointerException("Cannot accept null parameters!");
            }
            if (nodeToMoveFqn.getParent().equals(newParentFqn)) {
                if (trace) {
                    log.trace((Object)"Not doing anything as this node is equal with its parent");
                }
                return;
            }
            this.startAtomic();
            try {
                Node<K, V> nodeToMove = this.getNode(nodeToMoveFqn, Flag.FORCE_WRITE_LOCK);
                if (nodeToMove == null) {
                    if (trace) {
                        log.trace((Object)"Did not find the node that needs to be moved. Returning...");
                    }
                    return;
                }
                if (!this.exists(newParentFqn)) {
                    this.createNodeInCache(newParentFqn);
                    if (trace) {
                        log.tracef("The new parent (%s) did not exists, was created", (Object)newParentFqn);
                    }
                }
                Fqn newFqn = Fqn.fromRelativeElements(newParentFqn, nodeToMoveFqn.getLastElement());
                this.createNodeInCache(newFqn);
                Node<K, V> newNode = this.getNode(newFqn);
                Map<K, V> oldData = nodeToMove.getData();
                if (oldData != null && !oldData.isEmpty()) {
                    newNode.putAll(oldData);
                }
                for (Object child : nodeToMove.getChildrenNames()) {
                    if (trace) {
                        log.tracef("Moving child %s", child);
                    }
                    Fqn oldChildFqn = Fqn.fromRelativeElements(nodeToMoveFqn, child);
                    this.move(oldChildFqn, newFqn);
                }
                this.removeNode(nodeToMoveFqn);
            }
            finally {
                this.endAtomic();
            }
            log.tracef("Successfully moved node '%s' to '%s'", (Object)nodeToMoveFqn, (Object)newParentFqn);
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.move(Fqn.fromString(nodeToMove), Fqn.fromString(newParent), null);
    }

    @Override
    public void move(String nodeToMove, String newParent, Flag ... flags) throws NodeNotExistsException {
        this.move(Fqn.fromString(nodeToMove), Fqn.fromString(newParent), flags);
    }

    @Override
    public Map<K, V> getData(Fqn fqn) {
        return this.getData(fqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getData(Fqn fqn, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            Node<K, V> node;
            block8: {
                Map<K, V> map;
                this.startAtomic();
                try {
                    node = this.getNode(fqn);
                    if (node != null) break block8;
                    map = null;
                }
                catch (Throwable throwable) {
                    this.endAtomic();
                    throw throwable;
                }
                this.endAtomic();
                return map;
            }
            Map<K, V> map = node.getData();
            this.endAtomic();
            return map;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public Set<K> getKeys(String fqn) {
        return this.getKeys(Fqn.fromString(fqn), null);
    }

    @Override
    public Set<K> getKeys(String fqn, Flag ... flags) {
        return this.getKeys(Fqn.fromString(fqn), flags);
    }

    @Override
    public Set<K> getKeys(Fqn fqn) {
        return this.getKeys(fqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys(Fqn fqn, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            Node<K, V> node;
            block8: {
                Set<K> set;
                this.startAtomic();
                try {
                    node = this.getNode(fqn);
                    if (node != null) break block8;
                    set = null;
                }
                catch (Throwable throwable) {
                    this.endAtomic();
                    throw throwable;
                }
                this.endAtomic();
                return set;
            }
            Set<K> set = node.getKeys();
            this.endAtomic();
            return set;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public void clearData(String fqn) {
        this.clearData(Fqn.fromString(fqn), null);
    }

    @Override
    public void clearData(String fqn, Flag ... flags) {
        this.clearData(Fqn.fromString(fqn), flags);
    }

    @Override
    public void clearData(Fqn fqn) {
        this.clearData(fqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(Fqn fqn, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            this.startAtomic();
            try {
                Node<K, V> node = this.getNode(fqn);
                if (node != null) {
                    node.clearData();
                }
            }
            finally {
                this.endAtomic();
            }
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V put(Fqn fqn, K key, V value) {
        return this.put(fqn, key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(Fqn fqn, K key, V value, Flag ... flags) {
        this.setFlagsOnContext(flags);
        try {
            V v;
            this.startAtomic();
            try {
                this.createNodeInCache(fqn);
                AtomicMap<K, V> m = this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.DATA));
                v = m.put(key, value);
            }
            catch (Throwable throwable) {
                this.endAtomic();
                throw throwable;
            }
            this.endAtomic();
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public Cache<?, ?> getCache() {
        return this.cache.getAdvancedCache();
    }

    public void start() throws CacheException {
        this.cache.start();
        this.createRoot();
    }

    public void stop() {
        this.cache.stop();
    }

    private void createRoot() {
        if (!this.exists(Fqn.ROOT)) {
            this.createNodeInCache(Fqn.ROOT);
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

