/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicHashMapProxy;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.batch.BatchContainer;
import org.infinispan.context.Flag;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.TreeStructureSupport;
import org.infinispan.util.Immutables;
import org.infinispan.util.Util;

public class NodeImpl<K, V>
extends TreeStructureSupport
implements Node<K, V> {
    Fqn fqn;
    NodeKey dataKey;
    NodeKey structureKey;

    public NodeImpl(Fqn fqn, AdvancedCache<?, ?> cache, BatchContainer batchContainer) {
        super(cache, batchContainer);
        this.fqn = fqn;
        this.dataKey = new NodeKey(fqn, NodeKey.Type.DATA);
        this.structureKey = new NodeKey(fqn, NodeKey.Type.STRUCTURE);
    }

    @Override
    public Node<K, V> getParent() {
        return this.getParent(this.cache);
    }

    @Override
    public Node<K, V> getParent(Flag ... flags) {
        return this.getParent(this.cache.withFlags(flags));
    }

    private Node<K, V> getParent(AdvancedCache<?, ?> cache) {
        if (this.fqn.isRoot()) {
            return this;
        }
        return new NodeImpl<K, V>(this.fqn.getParent(), cache, this.batchContainer);
    }

    @Override
    public Set<Node<K, V>> getChildren() {
        return this.getChildren(this.cache);
    }

    @Override
    public Set<Node<K, V>> getChildren(Flag ... flags) {
        return this.getChildren(this.cache.withFlags(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Node<K, V>> getChildren(AdvancedCache<?, ?> cache) {
        this.startAtomic();
        try {
            HashSet<NodeImpl<K, V>> result = new HashSet<NodeImpl<K, V>>();
            for (Fqn f : this.getStructure().values()) {
                NodeImpl<K, V> n = new NodeImpl<K, V>(f, cache, this.batchContainer);
                result.add(n);
            }
            Set set = Immutables.immutableSetWrap(result);
            return set;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Set<Object> getChildrenNames() {
        return this.getChildrenNames(this.cache);
    }

    @Override
    public Set<Object> getChildrenNames(Flag ... flags) {
        return this.getChildrenNames(this.cache.withFlags(flags));
    }

    private Set<Object> getChildrenNames(AdvancedCache<?, ?> cache) {
        return Immutables.immutableSetCopy((Set)this.getStructure(cache).keySet());
    }

    @Override
    public Map<K, V> getData() {
        return this.getData(this.cache);
    }

    @Override
    public Map<K, V> getData(Flag ... flags) {
        return this.getData(this.cache.withFlags(flags));
    }

    private Map<K, V> getData(AdvancedCache<?, ?> cache) {
        return Collections.unmodifiableMap(new HashMap<K, V>(this.getDataInternal(cache)));
    }

    @Override
    public Set<K> getKeys() {
        return this.getKeys(this.cache);
    }

    @Override
    public Set<K> getKeys(Flag ... flags) {
        return this.getKeys(this.cache.withFlags(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<K> getKeys(AdvancedCache<?, ?> cache) {
        this.startAtomic();
        try {
            Set<K> set = this.getData(cache).keySet();
            return set;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Fqn getFqn() {
        return this.fqn;
    }

    @Override
    public Node<K, V> addChild(Fqn f) {
        return this.addChild(this.cache, f);
    }

    @Override
    public Node<K, V> addChild(Fqn f, Flag ... flags) {
        return this.addChild(this.cache.withFlags(flags), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V> addChild(AdvancedCache<?, ?> cache, Fqn f) {
        this.startAtomic();
        try {
            Fqn absoluteChildFqn = Fqn.fromRelativeFqn(this.fqn, f);
            AtomicMap<Object, Fqn> structureMap = this.getStructure(cache);
            structureMap.put(f.getLastElement(), (Object)absoluteChildFqn);
            this.createNodeInCache(cache, absoluteChildFqn);
            NodeImpl<K, V> nodeImpl = new NodeImpl<K, V>(absoluteChildFqn, cache, this.batchContainer);
            return nodeImpl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public boolean removeChild(Fqn f) {
        return this.removeChild(this.cache, f);
    }

    @Override
    public boolean removeChild(Fqn f, Flag ... flags) {
        return this.removeChild(this.cache.withFlags(flags), f);
    }

    public boolean removeChild(AdvancedCache<?, ?> cache, Fqn f) {
        return this.removeChild(cache, f.getLastElement());
    }

    @Override
    public boolean removeChild(Object childName) {
        return this.removeChild(this.cache, childName);
    }

    @Override
    public boolean removeChild(Object childName, Flag ... flags) {
        return this.removeChild(this.cache.withFlags(flags), childName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeChild(AdvancedCache cache, Object childName) {
        this.startAtomic();
        try {
            AtomicMap<Object, Fqn> s = this.getStructure(cache);
            Fqn childFqn = (Fqn)s.remove(childName);
            if (childFqn != null) {
                NodeImpl<K, V> child = new NodeImpl<K, V>(childFqn, cache, this.batchContainer);
                child.removeChildren();
                child.clearData();
                cache.remove((Object)new NodeKey(childFqn, NodeKey.Type.DATA));
                cache.remove((Object)new NodeKey(childFqn, NodeKey.Type.STRUCTURE));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> getChild(Fqn f) {
        return this.getChild(this.cache, f);
    }

    @Override
    public Node<K, V> getChild(Fqn f, Flag ... flags) {
        return this.getChild(this.cache.withFlags(flags), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V> getChild(AdvancedCache cache, Fqn f) {
        this.startAtomic();
        try {
            if (this.hasChild(f)) {
                NodeImpl<K, V> nodeImpl = new NodeImpl<K, V>(Fqn.fromRelativeFqn(this.fqn, f), cache, this.batchContainer);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> getChild(Object name) {
        return this.getChild(this.cache, name);
    }

    @Override
    public Node<K, V> getChild(Object name, Flag ... flags) {
        return this.getChild(this.cache.withFlags(flags), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V> getChild(AdvancedCache cache, Object name) {
        this.startAtomic();
        try {
            if (this.hasChild(name)) {
                NodeImpl<K, V> nodeImpl = new NodeImpl<K, V>(Fqn.fromRelativeElements(this.fqn, name), cache, this.batchContainer);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put(this.cache, key, value);
    }

    @Override
    public V put(K key, V value, Flag ... flags) {
        return this.put(this.cache.withFlags(flags), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(AdvancedCache cache, K key, V value) {
        this.startAtomic();
        try {
            AtomicHashMapProxy map = (AtomicHashMapProxy)this.getDataInternal(cache);
            Object object = map.put(key, value);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(this.cache, key, value);
    }

    @Override
    public V putIfAbsent(K key, V value, Flag ... flags) {
        return this.putIfAbsent(this.cache.withFlags(flags), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putIfAbsent(AdvancedCache<?, ?> cache, K key, V value) {
        this.startAtomic();
        try {
            AtomicMap<K, V> data = this.getDataInternal(cache);
            if (!data.containsKey(key)) {
                Object object = data.put(key, value);
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V replace(K key, V value) {
        return this.replace(this.cache, key, value);
    }

    @Override
    public V replace(K key, V value, Flag ... flags) {
        return this.replace(this.cache.withFlags(flags), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V replace(AdvancedCache<?, ?> cache, K key, V value) {
        this.startAtomic();
        try {
            AtomicMap map = this.getAtomicMap(cache, this.dataKey);
            if (map.containsKey(key)) {
                Object object = map.put(key, value);
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(this.cache, key, oldValue, newValue);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, Flag ... flags) {
        return this.replace(this.cache.withFlags(flags), key, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replace(AdvancedCache<?, ?> cache, K key, V oldValue, V newValue) {
        this.startAtomic();
        try {
            AtomicMap<K, V> data = this.getDataInternal(cache);
            Object old = data.get(key);
            if (Util.safeEquals(oldValue, (Object)old)) {
                data.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(this.cache, map);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Flag ... flags) {
        this.putAll(this.cache.withFlags(flags), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAll(AdvancedCache cache, Map<? extends K, ? extends V> map) {
        this.startAtomic();
        try {
            this.getDataInternal(cache).putAll(map);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map) {
        this.replaceAll(this.cache, map);
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map, Flag ... flags) {
        this.replaceAll(this.cache.withFlags(flags), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAll(AdvancedCache cache, Map<? extends K, ? extends V> map) {
        this.startAtomic();
        try {
            AtomicMap<K, V> data = this.getDataInternal(cache);
            data.clear();
            data.putAll(map);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V get(K key) {
        return this.get(this.cache, key);
    }

    @Override
    public V get(K key, Flag ... flags) {
        return this.get(this.cache.withFlags(flags), key);
    }

    private V get(AdvancedCache cache, K key) {
        return this.getData(cache).get(key);
    }

    @Override
    public V remove(K key) {
        return this.remove(this.cache, key);
    }

    @Override
    public V remove(K key, Flag ... flags) {
        return this.remove(this.cache.withFlags(flags), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V remove(AdvancedCache cache, K key) {
        this.startAtomic();
        try {
            Object object = this.getDataInternal(cache).remove(key);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void clearData() {
        this.clearData(this.cache);
    }

    @Override
    public void clearData(Flag ... flags) {
        this.clearData(this.cache.withFlags(flags));
    }

    private void clearData(AdvancedCache<?, ?> cache) {
        this.getDataInternal(cache).clear();
    }

    @Override
    public int dataSize() {
        return this.dataSize(this.cache);
    }

    @Override
    public int dataSize(Flag ... flags) {
        return this.dataSize(this.cache.withFlags(flags));
    }

    private int dataSize(AdvancedCache<?, ?> cache) {
        return this.getData(cache).size();
    }

    @Override
    public boolean hasChild(Fqn f) {
        return this.hasChild(this.cache, f);
    }

    @Override
    public boolean hasChild(Fqn f, Flag ... flags) {
        return this.hasChild(this.cache.withFlags(flags), f);
    }

    private boolean hasChild(AdvancedCache<?, ?> cache, Fqn f) {
        if (f.size() > 1) {
            Fqn absoluteFqn = Fqn.fromRelativeFqn(this.fqn, f);
            return this.exists(cache, absoluteFqn);
        }
        return this.hasChild(f.getLastElement());
    }

    @Override
    public boolean hasChild(Object o) {
        return this.hasChild(this.cache, o);
    }

    @Override
    public boolean hasChild(Object o, Flag ... flags) {
        return this.hasChild(this.cache.withFlags(flags), o);
    }

    private boolean hasChild(AdvancedCache<?, ?> cache, Object o) {
        return this.getStructure(cache).containsKey(o);
    }

    @Override
    public boolean isValid() {
        return this.cache.containsKey((Object)this.dataKey);
    }

    @Override
    public void removeChildren() {
        this.removeChildren(this.cache);
    }

    @Override
    public void removeChildren(Flag ... flags) {
        this.removeChildren(this.cache.withFlags(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildren(AdvancedCache<?, ?> cache) {
        this.startAtomic();
        try {
            AtomicMap<Object, Fqn> s = this.getStructure(cache);
            for (Object o : Immutables.immutableSetCopy(s.keySet())) {
                this.removeChild(cache, o);
            }
        }
        finally {
            this.endAtomic();
        }
    }

    AtomicMap<K, V> getDataInternal(AdvancedCache<?, ?> cache) {
        return this.getAtomicMap(cache, this.dataKey);
    }

    AtomicMap<Object, Fqn> getStructure() {
        return this.getAtomicMap(this.structureKey);
    }

    private AtomicMap<Object, Fqn> getStructure(AdvancedCache<?, ?> cache) {
        return this.getAtomicMap(cache, this.structureKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        return !(this.fqn != null ? !this.fqn.equals(node.fqn) : node.fqn != null);
    }

    public int hashCode() {
        return this.fqn != null ? this.fqn.hashCode() : 0;
    }

    public String toString() {
        return "NodeImpl{fqn=" + this.fqn + '}';
    }
}

