/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.impl.NodeKey;
import org.infinispan.tree.impl.TreeCacheImpl;
import org.infinispan.tree.impl.TreeStructureSupport;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.BaseNodeMoveAPITest")
public abstract class BaseNodeMoveAPITest
extends SingleCacheManagerTest {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final Fqn A = Fqn.fromString((String)"/a");
    protected static final Fqn B = Fqn.fromString((String)"/b");
    protected static final Fqn C = Fqn.fromString((String)"/c");
    protected static final Fqn D = Fqn.fromString((String)"/d");
    protected static final Fqn E = Fqn.fromString((String)"/e");
    static final Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
    static final Fqn A_B_C = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)C);
    static final Fqn A_B_C_E = Fqn.fromRelativeFqn((Fqn)A_B_C, (Fqn)E);
    static final Fqn C_E = Fqn.fromRelativeFqn((Fqn)C, (Fqn)E);
    static final Fqn D_B = Fqn.fromRelativeFqn((Fqn)D, (Fqn)B);
    static final Fqn D_B_C = Fqn.fromRelativeFqn((Fqn)D_B, (Fqn)C);
    protected static final Object k = "key";
    protected static final Object vA = "valueA";
    protected static final Object vB = "valueB";
    protected static final Object vC = "valueC";
    protected static final Object vD = "valueD";
    protected static final Object vE = "valueE";
    TreeCacheImpl<Object, Object> treeCache;
    TransactionManager tm;
    DataContainer dc;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager();
        cm.defineConfiguration("test", this.createConfigurationBuilder().build());
        this.cache = cm.getCache("test");
        this.tm = (TransactionManager)TestingUtil.extractComponent((Cache)this.cache, TransactionManager.class);
        this.treeCache = new TreeCacheImpl(this.cache);
        this.dc = (DataContainer)TestingUtil.extractComponent((Cache)this.cache, DataContainer.class);
        return cm;
    }

    protected abstract ConfigurationBuilder createConfigurationBuilder();

    public void testBasicMove() {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertEquals((String)("" + nodeA), (Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        this.log.info((Object)("BEFORE MOVE " + this.treeCache));
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        nodeC = this.treeCache.getNode(Fqn.fromRelativeFqn((Fqn)nodeB.getFqn(), (Fqn)C));
        this.log.info((Object)("POST MOVE " + this.treeCache));
        this.log.info((Object)("HC " + nodeC + " " + Util.hexIdHashCode((Object)nodeC)));
        Node x = this.treeCache.getRoot().getChild(Fqn.fromString((String)"b/c"));
        this.log.info((Object)("HC " + x + " " + Util.hexIdHashCode((Object)x)));
        AssertJUnit.assertEquals((String)("NODE C " + nodeC), (String)"/b/c", (String)nodeC.getFqn().toString());
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeB.hasChild(C));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((String)("B is parent of C: " + nodeB), (Object)nodeB, (Object)nodeC.getParent());
    }

    private Node<Object, Object> genericize(Node node) {
        return node;
    }

    public void testMoveWithChildren() {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        Node nodeD = nodeC.addChild(D);
        nodeD.put(k, vD);
        Node nodeE = nodeD.addChild(E);
        nodeE.put(k, vE);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
        this.log.info((Object)("move " + nodeC + " to " + nodeB));
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        nodeC = nodeB.getChild(C);
        nodeD = nodeC.getChild(D);
        nodeE = nodeD.getChild(E);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeB.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeB, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
    }

    public void testTxCommit() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
        this.tm.begin();
        this.log.debugf("Before: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.treeCache.move(nodeB.getFqn(), Fqn.ROOT);
        this.log.debugf("After: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.tm.commit();
        this.log.debugf("Committed: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        nodeB = rootNode.getChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeB));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().isEmpty());
    }

    public void testTxRollback() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
        this.tm.begin();
        this.log.debugf("Before: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.treeCache.move(nodeB.getFqn(), Fqn.ROOT);
        this.log.debugf("After: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.tm.rollback();
        this.log.debugf("Rolled back: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        nodeA = rootNode.getChild(A);
        nodeB = nodeA.getChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
    }

    public void testLocksDeepMove() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeD = nodeB.addChild(D);
        Node nodeC = rootNode.addChild(C);
        Node nodeE = nodeC.addChild(E);
        this.assertNoLocks();
        this.tm.begin();
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(C, true));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(C_E, true));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(A_B, false));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(A_B_C, true));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(A_B_C_E, true));
        this.tm.commit();
        this.assertNoLocks();
    }

    public void testLocks() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeC = rootNode.addChild(C);
        this.assertNoLocks();
        this.tm.begin();
        this.treeCache.move(nodeC.getFqn(), nodeB.getFqn());
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(C, true));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(A_B_C, true));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(Fqn.ROOT, false));
        AssertJUnit.assertTrue((boolean)this.isNodeLocked(A_B, false));
        this.tm.commit();
        this.assertNoLocks();
    }

    public void testConcurrentMoveSiblings() throws Exception {
        int N = 5;
        Fqn X = Fqn.fromString((String)"/x");
        Fqn Y = Fqn.fromString((String)"/y");
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.addChild(X);
        nodeA.addChild(Y);
        Node nodeB = rootNode.addChild(B);
        Node nodeC = rootNode.addChild(C);
        Callable[] movers = new Callable[5];
        for (int i = 0; i < 5; ++i) {
            final Fqn source = Fqn.fromRelativeFqn((Fqn)A, (Fqn)(i % 2 == 0 ? X : Y));
            final Fqn dest = i % 2 == 0 ? B : C;
            movers[i] = new Callable<Object>(){

                @Override
                public Object call() {
                    try {
                        BaseNodeMoveAPITest.this.treeCache.move(source, dest);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            };
        }
        this.runConcurrently(movers);
        this.log.info((Object)("Tree: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true)));
        this.assertNoLocks();
        AssertJUnit.assertTrue((boolean)(nodeA.getChildrenNames().contains("x") ^ nodeB.getChildrenNames().contains("x")));
        AssertJUnit.assertTrue((boolean)(nodeA.getChildrenNames().contains("y") ^ nodeC.getChildrenNames().contains("y")));
    }

    public void testConcurrentMoveToSameDest() throws Exception {
        int N = 5;
        Fqn X = Fqn.fromString((String)"/x");
        Fqn Y = Fqn.fromString((String)"/y");
        Node rootNode = this.treeCache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.addChild(X);
        Node nodeB = rootNode.addChild(B);
        nodeB.addChild(Y);
        Node nodeC = rootNode.addChild(C);
        Callable[] movers = new Callable[5];
        for (int i = 0; i < 5; ++i) {
            final Fqn source = i % 2 == 0 ? Fqn.fromRelativeFqn((Fqn)A, (Fqn)X) : Fqn.fromRelativeFqn((Fqn)B, (Fqn)Y);
            movers[i] = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        BaseNodeMoveAPITest.this.treeCache.move(source, C);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            };
        }
        this.runConcurrently(movers);
        this.log.info((Object)("Tree: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true)));
        this.assertNoLocks();
        AssertJUnit.assertTrue((boolean)(nodeA.getChildrenNames().contains("x") ^ nodeC.getChildrenNames().contains("x")));
        AssertJUnit.assertTrue((boolean)(nodeB.getChildrenNames().contains("y") ^ nodeC.getChildrenNames().contains("y")));
    }

    public void testConcurrentMoveSameNode() throws Exception {
        Node rootNode = this.treeCache.getRoot();
        final Fqn FQN_A = A;
        final Fqn FQN_B = B;
        final Fqn FQN_C = C;
        Node nodeA = rootNode.addChild(FQN_A);
        Node nodeB = rootNode.addChild(FQN_B);
        Node nodeC = rootNode.addChild(FQN_C);
        final CountDownLatch nodeReadLatch = new CountDownLatch(1);
        final CountDownLatch nodeMovedLatch = new CountDownLatch(1);
        Callable<Object> moveCtoB = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                block4: {
                    BaseNodeMoveAPITest.this.tm().begin();
                    try {
                        AssertJUnit.assertEquals((Object)BaseNodeMoveAPITest.this.asSet(new Object[]{"a", "b", "c"}), (Object)BaseNodeMoveAPITest.this.treeCache.getRoot().getChildrenNames());
                        AssertJUnit.assertEquals(Collections.emptySet(), (Object)BaseNodeMoveAPITest.this.treeCache.getNode(FQN_C).getChildrenNames());
                        nodeReadLatch.countDown();
                        nodeMovedLatch.await();
                        BaseNodeMoveAPITest.this.treeCache.move(FQN_C, FQN_B);
                        BaseNodeMoveAPITest.this.tm().commit();
                        AssertJUnit.fail((String)"Transaction should have failed");
                    }
                    catch (Exception e) {
                        if (BaseNodeMoveAPITest.this.tm().getTransaction() == null) break block4;
                        try {
                            BaseNodeMoveAPITest.this.tm().rollback();
                        }
                        catch (SystemException e1) {
                            BaseNodeMoveAPITest.this.log.error((Object)"Failed to rollback", (Throwable)e1);
                        }
                    }
                }
                return null;
            }
        };
        Callable<Object> moveCtoA = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                BaseNodeMoveAPITest.this.tm().begin();
                try {
                    try {
                        nodeReadLatch.await();
                        BaseNodeMoveAPITest.this.treeCache.move(FQN_C, FQN_A);
                        BaseNodeMoveAPITest.this.tm().commit();
                    }
                    finally {
                        nodeMovedLatch.countDown();
                    }
                }
                catch (Exception e) {
                    if (BaseNodeMoveAPITest.this.tm().getTransaction() != null) {
                        try {
                            BaseNodeMoveAPITest.this.tm().rollback();
                        }
                        catch (SystemException e1) {
                            BaseNodeMoveAPITest.this.log.error((Object)"Failed to rollback", (Throwable)e1);
                        }
                    }
                    throw e;
                }
                return null;
            }
        };
        this.runConcurrently(new Callable[]{moveCtoB, moveCtoA});
        this.log.trace((Object)("Tree: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true)));
        this.assertNoLocks();
        AssertJUnit.assertFalse((boolean)nodeC.isValid());
        AssertJUnit.assertEquals(this.asSet("a", "b"), (Object)rootNode.getChildrenNames());
        AssertJUnit.assertEquals(this.asSet("c"), (Object)nodeA.getChildrenNames());
        AssertJUnit.assertEquals(Collections.emptySet(), (Object)nodeB.getChildrenNames());
    }

    public void testMoveInSamePlace() {
        Node rootNode = this.treeCache.getRoot();
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Node aNode = rootNode.addChild(A);
        Node xNode = aNode.addChild(FQN_X);
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
        this.log.debugf("Before: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.treeCache.move(xNode.getFqn(), aNode.getFqn());
        this.log.debugf("After: " + TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.assertNoLocks();
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
    }

    protected CacheEntry lookupEntryFromCurrentTransaction(TransactionTable transactionTable, TransactionManager transactionManager, Object key) {
        try {
            LocalTransaction localTransaction = transactionTable.getLocalTransaction(transactionManager.getTransaction());
            return localTransaction == null ? null : localTransaction.lookupEntry(key);
        }
        catch (SystemException e) {
            return null;
        }
    }

    protected boolean isNodeLocked(Fqn fqn, boolean includeData) {
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        TransactionTable tt = (TransactionTable)this.cache.getAdvancedCache().getComponentRegistry().getComponent(TransactionTable.class);
        CacheEntry structure = this.lookupEntryFromCurrentTransaction(tt, tm, new NodeKey(fqn, NodeKey.Type.STRUCTURE));
        CacheEntry data = this.lookupEntryFromCurrentTransaction(tt, tm, new NodeKey(fqn, NodeKey.Type.DATA));
        return structure != null && data != null && structure.isChanged() && (!includeData || data.isChanged());
    }

    protected void assertNoLocks() {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)this.cache);
        LockManager lm = (LockManager)cr.getComponent(LockManager.class);
        LockAssert.assertNoLocks((LockManager)lm);
    }

    public void testNonexistentSource() {
        this.treeCache.put(A_B_C, (Object)"k", (Object)"v");
        assert ("v".equals(this.treeCache.get(A_B_C, (Object)"k")));
        assert (1 == this.treeCache.getNode(A_B).getChildren().size());
        assert (this.treeCache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (!this.treeCache.getNode(A_B).getChildrenNames().contains(D.getLastElement()));
        this.treeCache.move(D, A_B);
        assert ("v".equals(this.treeCache.get(A_B_C, (Object)"k")));
        assert (1 == this.treeCache.getNode(A_B).getChildren().size());
        assert (this.treeCache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (!this.treeCache.getNode(A_B).getChildrenNames().contains(D.getLastElement()));
    }

    public void testNonexistentTarget() {
        this.treeCache.put(A_B_C, (Object)"k", (Object)"v");
        assert ("v".equals(this.treeCache.get(A_B_C, (Object)"k")));
        assert (1 == this.treeCache.getNode(A_B).getChildren().size());
        assert (this.treeCache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (null == this.treeCache.getNode(D));
        this.log.debugf(TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        this.treeCache.move(A_B, D);
        this.log.debugf(TreeStructureSupport.printTree(this.treeCache, (boolean)true), new Object[0]);
        assert (null == this.treeCache.getNode(A_B_C));
        assert (null == this.treeCache.getNode(A_B));
        assert (null != this.treeCache.getNode(D));
        assert (null != this.treeCache.getNode(D_B));
        assert (null != this.treeCache.getNode(D_B_C));
        assert ("v".equals(this.treeCache.get(D_B_C, (Object)"k")));
    }

    private Set<Object> asSet(Object ... names) {
        return Util.asSet((Object[])names);
    }
}

