/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.FlagTest")
public class FlagTest
extends MultipleCacheManagersTest {
    private Cache<String, String> cache1;
    private Cache<String, String> cache2;
    private TreeCache<String, String> treeCache1;
    private TreeCache<String, String> treeCache2;
    private static final String KEY = "key";
    private static final Log log = LogFactory.getLog(FlagTest.class);

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = FlagTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.INVALIDATION_SYNC, (boolean)true);
        cb.invocationBatching().enable();
        this.createClusteredCaches(2, "invalidatedFlagCache", cb);
        this.cache1 = this.cache(0, "invalidatedFlagCache");
        this.cache2 = this.cache(1, "invalidatedFlagCache");
        TreeCacheFactory tcf = new TreeCacheFactory();
        this.treeCache1 = tcf.createTreeCache(this.cache1);
        this.treeCache2 = tcf.createTreeCache(this.cache2);
    }

    public void testTreeCacheLocalPut() throws Exception {
        Fqn fqn = Fqn.fromElements((Object[])new Object[]{"TEST"});
        this.treeCache1.put(fqn, (Object)KEY, (Object)"1", new Flag[]{Flag.CACHE_MODE_LOCAL});
        this.treeCache2.put(fqn, (Object)KEY, (Object)"2", new Flag[]{Flag.CACHE_MODE_LOCAL});
        assert ("2".equals(this.treeCache2.get(fqn, (Object)KEY))) : "treeCache2 was updated locally";
        assert ("1".equals(this.treeCache1.get(fqn, (Object)KEY))) : "treeCache1 should not be invalidated in case of LOCAL put in treeCache2";
        String fqnString = "fqnAsString";
        this.treeCache1.put(fqnString, (Object)KEY, (Object)"3", new Flag[]{Flag.CACHE_MODE_LOCAL});
        this.treeCache2.put(fqnString, (Object)KEY, (Object)"4", new Flag[]{Flag.CACHE_MODE_LOCAL});
        assert ("4".equals(this.treeCache2.get(fqnString, (Object)KEY))) : "treeCache2 was updated locally";
        assert ("3".equals(this.treeCache1.get(fqnString, (Object)KEY))) : "treeCache1 should not be invalidated in case of LOCAL put in treeCache2";
    }

    public void testWithFlags() {
        AdvancedCache localCache1 = this.cache1.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        AdvancedCache localCache2 = this.cache2.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        TreeCache treeCache1 = new TreeCacheFactory().createTreeCache((Cache)localCache1);
        TreeCache treeCache2 = new TreeCacheFactory().createTreeCache((Cache)localCache2);
        Fqn fqn = Fqn.fromElements((Object[])new Object[]{"TEST_WITH_FLAGS"});
        treeCache1.put(fqn, (Object)KEY, (Object)"1");
        treeCache2.put(fqn, (Object)KEY, (Object)"2");
        assert ("2".equals(treeCache2.get(fqn, (Object)KEY))) : "treeCache2 was updated locally";
        assert ("1".equals(treeCache1.get(fqn, (Object)KEY))) : "treeCache1 should not be invalidated in case of LOCAL put in treeCache2";
    }
}

