/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.impl.TreeCacheImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.SyncReplTest")
public class SyncReplTest
extends MultipleCacheManagersTest {
    private TreeCache<Object, Object> cache1;
    private TreeCache<Object, Object> cache2;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = SyncReplTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cb.invocationBatching().enable();
        this.createClusteredCaches(2, "replSync", cb);
        Cache c1 = this.cache(0, "replSync");
        Cache c2 = this.cache(1, "replSync");
        this.cache1 = new TreeCacheImpl(c1);
        this.cache2 = new TreeCacheImpl(c2);
    }

    public void testBasicOperation() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Fqn f = Fqn.fromString((String)"/test/data");
        String k = "key";
        String v = "value";
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getRoot().getChild(f));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getRoot().getChild(f));
        Node node = this.cache1.getRoot().addChild(f);
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)node);
        node.put((Object)k, (Object)v);
        AssertJUnit.assertEquals((Object)v, (Object)node.get((Object)k));
        AssertJUnit.assertEquals((Object)v, (Object)this.cache1.get(f, (Object)k));
        assert (v.equals(this.cache2.get(f, (Object)k)));
    }

    public void testSyncRepl() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Fqn fqn = Fqn.fromString((String)"/JSESSIONID/1010.10.5:3000/1234567890/1");
        this.cache1.getCache().getCacheConfiguration().transaction().syncCommitPhase(true);
        this.cache2.getCache().getCacheConfiguration().transaction().syncCommitPhase(true);
        this.cache1.put(fqn, (Object)"age", (Object)38);
        AssertJUnit.assertEquals((String)"Value should be set", (Object)38, (Object)this.cache1.get(fqn, (Object)"age"));
        AssertJUnit.assertEquals((String)"Value should have replicated", (Object)38, (Object)this.cache2.get(fqn, (Object)"age"));
    }

    public void testPutMap() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Fqn fqn = Fqn.fromString((String)"/JSESSIONID/10.10.10.5:3000/1234567890/1");
        Fqn fqn1 = Fqn.fromString((String)"/JSESSIONID/10.10.10.5:3000/1234567890/2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        this.cache1.getRoot().addChild(fqn).putAll(map, new Flag[]{Flag.SKIP_LOCKING});
        AssertJUnit.assertEquals((String)"Value should be set", (Object)"1", (Object)this.cache1.get(fqn, (Object)"1", new Flag[]{Flag.SKIP_LOCKING}));
        map = new HashMap();
        map.put("3", "3");
        map.put("4", "4");
        this.cache1.getRoot().addChild(fqn1).putAll(map, new Flag[]{Flag.SKIP_LOCKING});
        AssertJUnit.assertEquals((String)"Value should be set", (Object)"2", (Object)this.cache1.get(fqn, (Object)"2", new Flag[]{Flag.SKIP_LOCKING}));
    }
}

