/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.infinispan.tree.impl.NodeKey;
import org.infinispan.tree.impl.TreeCacheImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.tree.TreeCacheAPITest")
public class TreeCacheAPITest
extends SingleCacheManagerTest {
    private TreeCache<String, String> cache;
    private TransactionManager tm;
    private Log log = LogFactory.getLog(TreeCacheAPITest.class);

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.invocationBatching().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cb);
        Cache flatcache = cm.getCache();
        this.cache = new TreeCacheImpl(flatcache);
        this.tm = TestingUtil.getTransactionManager((Cache)flatcache);
        return cm;
    }

    public void testGetData() {
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key1", (Object)"TRADE1");
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key2", (Object)"TRADE2");
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key3", (Object)"TRADE3");
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key4", (Object)"TRADE4");
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key5", (Object)"TRADE5");
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key6", (Object)"TRADE6");
        this.cache.put(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key7", (Object)"TRADE7");
        Object object = this.cache.get(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")), (Object)"key7");
        AssertJUnit.assertNotNull((Object)object);
        Map data = this.cache.getData(Fqn.fromRelativeFqn((Fqn)Fqn.fromString((String)"STATUS"), (Fqn)Fqn.fromString((String)"TRADE")));
        AssertJUnit.assertNotNull((Object)data);
    }

    public void testConvenienceMethods() {
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        String key = "key";
        String value = "value";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)key));
        this.cache.put(fqn, (Object)key, (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.get(fqn, (Object)key)));
        this.cache.remove(fqn, (Object)key);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)key));
        this.cache.put(fqn, data);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.get(fqn, (Object)key)));
    }

    public void testNodeConvenienceNodeRemoval() {
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        this.cache.getRoot().addChild(fqn);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(fqn));
        Node n = this.cache.getNode(fqn);
        AssertJUnit.assertNull((Object)n);
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache.removeNode(fqn));
        n = this.cache.getNode(fqn);
        AssertJUnit.assertNull((Object)n);
        Fqn child = Fqn.fromString((String)"/test/fqn/child");
        this.log.error((Object)("TEST: Adding child " + child));
        this.cache.getRoot().addChild(child);
        this.assertStructure(this.cache, "/test/fqn/child");
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache.removeNode(fqn));
    }

    private void assertStructure(TreeCache tc, String fqnStr) {
        Cache c = tc.getCache();
        Fqn fqn = Fqn.fromString((String)fqnStr);
        for (int i = 0; i < fqn.size(); ++i) {
            Fqn parent = fqn.getSubFqn(0, i);
            Object childName = fqn.get(i);
            AssertJUnit.assertTrue((String)("Node [" + parent + "] does not have a Data atomic map!"), (boolean)c.containsKey((Object)new NodeKey(parent, NodeKey.Type.DATA)));
            AssertJUnit.assertTrue((String)("Node [" + parent + "] does not have a Structure atomic map!"), (boolean)c.containsKey((Object)new NodeKey(parent, NodeKey.Type.STRUCTURE)));
            AtomicMap am = AtomicMapLookup.getAtomicMap((Cache)c, (Object)new NodeKey(parent, NodeKey.Type.STRUCTURE));
            boolean hasChild = am.containsKey(childName);
            AssertJUnit.assertTrue((String)("Node [" + parent + "] does not have a child [" + childName + "] in its Structure atomic " + "map!"), (boolean)hasChild);
        }
    }

    public void testStopClearsData() throws Exception {
        Fqn a = Fqn.fromString((String)"/a");
        Fqn b = Fqn.fromString((String)"/a/b");
        String key = "key";
        String value = "value";
        this.cache.getRoot().addChild(a).put((Object)key, (Object)value);
        this.cache.getRoot().addChild(b).put((Object)key, (Object)value);
        this.cache.getRoot().put((Object)key, (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.getRoot().get((Object)key)));
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.getRoot().getChild(a).get((Object)key)));
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.getRoot().getChild(b).get((Object)key)));
        this.cache.stop();
        this.cache.start();
        AssertJUnit.assertNull((Object)this.cache.getRoot().get((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().getData().isEmpty());
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().getChildren().isEmpty());
    }

    public void testPhantomStructuralNodesOnRemove() {
        AssertJUnit.assertNull((Object)this.cache.getNode("/a/b/c"));
        AssertJUnit.assertFalse((boolean)this.cache.removeNode("/a/b/c"));
        AssertJUnit.assertNull((Object)this.cache.getNode("/a/b/c"));
        AssertJUnit.assertNull((Object)this.cache.getNode("/a/b"));
        AssertJUnit.assertNull((Object)this.cache.getNode("/a"));
    }

    public void testPhantomStructuralNodesOnRemoveTransactional() throws Exception {
        AssertJUnit.assertNull((Object)this.cache.getNode("/a/b/c"));
        this.tm.begin();
        AssertJUnit.assertFalse((boolean)this.cache.removeNode("/a/b/c"));
        this.tm.commit();
        AssertJUnit.assertNull((Object)this.cache.getNode("/a/b/c"));
        AssertJUnit.assertNull((Object)this.cache.getNode("/a/b"));
        AssertJUnit.assertNull((Object)this.cache.getNode("/a"));
    }

    public void testRpcManagerElements() {
        AssertJUnit.assertEquals((String)"CacheMode.LOCAL cache has no address", null, (Object)this.manager(this.cache.getCache()).getAddress());
        AssertJUnit.assertEquals((String)"CacheMode.LOCAL cache has no members list", null, (Object)this.manager(this.cache.getCache()).getMembers());
    }

    public void testTreeCacheFactory() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.invocationBatching().enable();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder)){

            public void call() {
                TreeCacheFactory tcf = new TreeCacheFactory();
                tcf.createTreeCache(this.cm.getCache());
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testFactoryNoBatching() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder)){

            public void call() {
                TreeCacheFactory tcf = new TreeCacheFactory();
                tcf.createTreeCache(this.cm.getCache());
            }
        });
    }
}

